/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class TwigletTreeFeature
extends TreeFeatureBase {
    private float leafChanceEven;
    private float leafChanceOdd;

    protected TwigletTreeFeature(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState altLeaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, int minHeight, int maxHeight, float leafChanceEven, float leafChanceOdd) {
        super(notify, placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.leafChanceEven = leafChanceEven;
        this.leafChanceOdd = leafChanceOdd;
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld world, Random random, BlockPos startPos) {
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = this.minHeight + random.nextInt(1 + this.maxHeight - this.minHeight);
        int baseHeight = height / 3;
        BlockPos pos = startPos.func_177984_a();
        for (int y = 0; y < height; ++y) {
            float leafChance;
            if (!this.setLog(changedBlocks, world, pos.func_177981_b(y))) {
                return true;
            }
            float f = leafChance = (height - y) % 2 == 0 ? this.leafChanceEven : this.leafChanceOdd;
            if (y <= baseHeight) continue;
            if (random.nextFloat() < leafChance) {
                this.setLeaves(world, pos.func_177982_a(1, y, 0));
            }
            if (random.nextFloat() < leafChance) {
                this.setLeaves(world, pos.func_177982_a(-1, y, 0));
            }
            if (random.nextFloat() < leafChance) {
                this.setLeaves(world, pos.func_177982_a(0, y, 1));
            }
            if (random.nextFloat() < leafChance) {
                this.setLeaves(world, pos.func_177982_a(0, y, -1));
            }
            if (this.trunkFruit == Blocks.field_150350_a.func_176223_P() || random.nextInt(3) != 0) continue;
            for (int l3 = 0; l3 < 2; ++l3) {
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    if (random.nextInt(4 - l3) != 0) continue;
                    EnumFacing enumfacing1 = enumfacing.func_176734_d();
                    this.generateTrunkFruit(world, random.nextInt(3), pos.func_177982_a(enumfacing1.func_82601_c(), 0, enumfacing1.func_82599_e()), enumfacing);
                }
            }
        }
        this.setLeaves(world, pos.func_177982_a(0, height, 0));
        return true;
    }

    private void generateTrunkFruit(IWorld world, int age, BlockPos pos, EnumFacing direction) {
        if (this.trunkFruit == Blocks.field_150375_by.func_176223_P()) {
            this.func_202278_a(world, pos, (IBlockState)((IBlockState)this.trunkFruit.func_206870_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(age))).func_206870_a((IProperty)BlockCocoa.field_185512_D, (Comparable)direction));
        } else {
            this.func_202278_a(world, pos, (IBlockState)this.trunkFruit.func_206870_a((IProperty)BlockCocoa.field_185512_D, (Comparable)direction));
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, TwigletTreeFeature> {
        protected float leafChanceEven;
        protected float leafChanceOdd;

        public Builder leafChance(float a) {
            this.leafChanceEven = a;
            this.leafChanceOdd = a;
            return this;
        }

        public Builder leafChance(float a, float b) {
            this.leafChanceEven = a;
            this.leafChanceOdd = b;
            return this;
        }

        public Builder() {
            this.minHeight = 2;
            this.maxHeight = 6;
            this.leafChanceEven = 0.2f;
            this.leafChanceOdd = 0.9f;
        }

        @Override
        public TwigletTreeFeature create() {
            return new TwigletTreeFeature(this.updateNeighbours, this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.leafChanceEven, this.leafChanceOdd);
        }
    }
}

