/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Optional;
import net.minecraft.init.Biomes;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IContext;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;

public enum GenLayerBiomeEdgeBOP implements ICastleTransformer
{
    INSTANCE;

    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int SNOWY_TUNDRA;
    private static final int JUNGLE;
    private static final int JUNGLE_EDGE;
    private static final int BADLANDS;
    private static final int BADLANDS_PLATEAU;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int PLAINS;
    private static final int GIANT_TREE_TAIGA;
    private static final int MOUNTAIN_EDGE;
    private static final int SWAMP;
    private static final int TAIGA;
    private static final int SNOWY_TAIGA;

    public int func_202748_a(IContext context, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId) {
        int[] outBiomeId = new int[1];
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.alps, BOPBiomes.alps_foothills)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.redwood_forest, BOPBiomes.redwood_forest_edge)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.volcano, BOPBiomes.volcano_edge)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdgeIfNecessary(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, MOUNTAINS, MOUNTAIN_EDGE)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, WOODED_BADLANDS_PLATEAU, BADLANDS)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BADLANDS_PLATEAU, BADLANDS)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, GIANT_TREE_TAIGA, TAIGA)) {
            return outBiomeId[0];
        }
        if (biomeId == DESERT && (northBiomeId == SNOWY_TUNDRA || eastBiomeId == SNOWY_TUNDRA || westBiomeId == SNOWY_TUNDRA || southBiomeId == SNOWY_TUNDRA)) {
            return WOODED_MOUNTAINS;
        }
        if (biomeId == SWAMP) {
            if (northBiomeId == DESERT || eastBiomeId == DESERT || westBiomeId == DESERT || southBiomeId == DESERT || northBiomeId == SNOWY_TAIGA || eastBiomeId == SNOWY_TAIGA || westBiomeId == SNOWY_TAIGA || southBiomeId == SNOWY_TAIGA || northBiomeId == SNOWY_TUNDRA || eastBiomeId == SNOWY_TUNDRA || westBiomeId == SNOWY_TUNDRA || southBiomeId == SNOWY_TUNDRA) {
                return PLAINS;
            }
            if (northBiomeId == JUNGLE || southBiomeId == JUNGLE || eastBiomeId == JUNGLE || westBiomeId == JUNGLE) {
                return JUNGLE_EDGE;
            }
        }
        return biomeId;
    }

    private boolean replaceBiomeEdgeIfNecessary(int[] outId, int northBiomeId, int southBiomeId, int eastBiomeId, int westBiomeId, int biomeId, int fromBiome, int toBiome) {
        if (!LayerUtil.func_202826_a((int)biomeId, (int)fromBiome)) {
            return false;
        }
        outId[0] = this.canBiomesBeNeighbors(northBiomeId, fromBiome) && this.canBiomesBeNeighbors(southBiomeId, fromBiome) && this.canBiomesBeNeighbors(westBiomeId, fromBiome) && this.canBiomesBeNeighbors(eastBiomeId, fromBiome) ? biomeId : toBiome;
        return true;
    }

    private boolean replaceBiomeEdge(int[] outId, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId, Optional<Biome> fromBiome, Optional<Biome> toBiome) {
        return fromBiome.isPresent() && toBiome.isPresent() && this.replaceBiomeEdge(outId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, IRegistry.field_212624_m.func_148757_b((Object)fromBiome.get()), IRegistry.field_212624_m.func_148757_b((Object)toBiome.get()));
    }

    private boolean replaceBiomeEdge(int[] outId, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId, int fromBiome, int toBiome) {
        if (biomeId != fromBiome) {
            return false;
        }
        outId[0] = LayerUtil.func_202826_a((int)northBiomeId, (int)fromBiome) && LayerUtil.func_202826_a((int)eastBiomeId, (int)fromBiome) && LayerUtil.func_202826_a((int)westBiomeId, (int)fromBiome) && LayerUtil.func_202826_a((int)southBiomeId, (int)fromBiome) ? biomeId : toBiome;
        return true;
    }

    private boolean canBiomesBeNeighbors(int biomeIdA, int biomeIdB) {
        if (LayerUtil.func_202826_a((int)biomeIdA, (int)biomeIdB)) {
            return true;
        }
        Biome biomeA = (Biome)IRegistry.field_212624_m.func_148754_a(biomeIdA);
        Biome biomeB = (Biome)IRegistry.field_212624_m.func_148754_a(biomeIdB);
        if (biomeA != null && biomeB != null) {
            Biome.TempCategory catB;
            Biome.TempCategory catA = biomeA.func_150561_m();
            return catA == (catB = biomeB.func_150561_m()) || catA == Biome.TempCategory.MEDIUM || catB == Biome.TempCategory.MEDIUM;
        }
        return false;
    }

    static {
        DESERT = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76769_d);
        MOUNTAINS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76770_e);
        WOODED_MOUNTAINS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150580_W);
        SNOWY_TUNDRA = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76774_n);
        JUNGLE = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76782_w);
        JUNGLE_EDGE = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150574_L);
        BADLANDS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150589_Z);
        BADLANDS_PLATEAU = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150608_ab);
        WOODED_BADLANDS_PLATEAU = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150607_aa);
        PLAINS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76772_c);
        GIANT_TREE_TAIGA = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150578_U);
        MOUNTAIN_EDGE = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76783_v);
        SWAMP = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76780_h);
        TAIGA = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76768_g);
        SNOWY_TAIGA = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150584_S);
    }
}

