/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.biome.BiomeBOP;
import biomesoplenty.common.world.BOPLayerUtil;
import net.minecraft.init.Biomes;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IContext;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;

public enum GenLayerShoreBOP implements ICastleTransformer
{
    INSTANCE;

    private static final int BEACH;
    private static final int SNOWY_BEACH;
    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int FOREST;
    private static final int JUNGLE;
    private static final int JUNGLE_EDGE;
    private static final int JUNGLE_HILLS;
    private static final int BADLANDS;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int BADLANDS_PLATEAU;
    private static final int ERODED_BADLANDS;
    private static final int MODIFIED_WOODED_BADLANDS_PLATEAU;
    private static final int MODIFIED_BADLANDS_PLATEAU;
    private static final int MUSHROOM_FIELDS;
    private static final int MUSHROOM_FIELD_SHORE;
    private static final int RIVER;
    private static final int MOUNTAIN_EDGE;
    private static final int STONE_SHORE;
    private static final int SWAMP;
    private static final int TAIGA;

    public int func_202748_a(IContext context, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId) {
        Biome biome = (Biome)IRegistry.field_212624_m.func_148754_a(biomeId);
        if (biomeId == MUSHROOM_FIELDS) {
            if (BOPLayerUtil.isShallowOcean(northBiomeId) || BOPLayerUtil.isShallowOcean(eastBiomeId) || BOPLayerUtil.isShallowOcean(southBiomeId) || BOPLayerUtil.isShallowOcean(westBiomeId)) {
                return MUSHROOM_FIELD_SHORE;
            }
        } else if (biome != null && biome.func_201856_r() == Biome.Category.JUNGLE) {
            if (!(GenLayerShoreBOP.isJungleCompatible(northBiomeId) && GenLayerShoreBOP.isJungleCompatible(eastBiomeId) && GenLayerShoreBOP.isJungleCompatible(southBiomeId) && GenLayerShoreBOP.isJungleCompatible(westBiomeId))) {
                return JUNGLE_EDGE;
            }
            if (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId)) {
                return BEACH;
            }
        } else if (biomeId != MOUNTAINS && biomeId != WOODED_MOUNTAINS && biomeId != MOUNTAIN_EDGE) {
            if (biome != null && biome.func_201851_b() == Biome.RainType.SNOW) {
                if (!BOPLayerUtil.isOcean(biomeId) && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
                    return SNOWY_BEACH;
                }
            } else if (biomeId != BADLANDS && biomeId != WOODED_BADLANDS_PLATEAU) {
                if (!BOPLayerUtil.isOcean(biomeId) && biomeId != RIVER && biomeId != SWAMP && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
                    if (biome instanceof BiomeBOP) {
                        BiomeBOP biomeBOP = (BiomeBOP)biome;
                        if (biomeBOP.beachBiomeId != -1) {
                            return biomeBOP.beachBiomeId;
                        }
                        return biomeId;
                    }
                    return BEACH;
                }
            } else if (!(BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId) || GenLayerShoreBOP.isMesa(northBiomeId) && GenLayerShoreBOP.isMesa(eastBiomeId) && GenLayerShoreBOP.isMesa(southBiomeId) && GenLayerShoreBOP.isMesa(westBiomeId))) {
                return DESERT;
            }
        } else if (!BOPLayerUtil.isOcean(biomeId) && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
            return STONE_SHORE;
        }
        return biomeId;
    }

    private static boolean isJungleCompatible(int biomeId) {
        if (IRegistry.field_212624_m.func_148754_a(biomeId) != null && ((Biome)IRegistry.field_212624_m.func_148754_a(biomeId)).func_201856_r() == Biome.Category.JUNGLE) {
            return true;
        }
        return biomeId == JUNGLE_EDGE || biomeId == JUNGLE || biomeId == JUNGLE_HILLS || biomeId == FOREST || biomeId == TAIGA || BOPLayerUtil.isOcean(biomeId);
    }

    private static boolean isMesa(int biomeId) {
        return biomeId == BADLANDS || biomeId == WOODED_BADLANDS_PLATEAU || biomeId == BADLANDS_PLATEAU || biomeId == ERODED_BADLANDS || biomeId == MODIFIED_WOODED_BADLANDS_PLATEAU || biomeId == MODIFIED_BADLANDS_PLATEAU;
    }

    static {
        BEACH = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76787_r);
        SNOWY_BEACH = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150577_O);
        DESERT = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76769_d);
        MOUNTAINS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76770_e);
        WOODED_MOUNTAINS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150580_W);
        FOREST = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76767_f);
        JUNGLE = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76782_w);
        JUNGLE_EDGE = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150574_L);
        JUNGLE_HILLS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76792_x);
        BADLANDS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150589_Z);
        WOODED_BADLANDS_PLATEAU = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150607_aa);
        BADLANDS_PLATEAU = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150608_ab);
        ERODED_BADLANDS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_185437_ai);
        MODIFIED_WOODED_BADLANDS_PLATEAU = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_185438_aj);
        MODIFIED_BADLANDS_PLATEAU = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_185439_ak);
        MUSHROOM_FIELDS = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76789_p);
        MUSHROOM_FIELD_SHORE = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76788_q);
        RIVER = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76781_i);
        MOUNTAIN_EDGE = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76783_v);
        STONE_SHORE = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_150576_N);
        SWAMP = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76780_h);
        TAIGA = IRegistry.field_212624_m.func_148757_b((Object)Biomes.field_76768_g);
    }
}

