/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.command;

import biomesoplenty.common.command.BiomeArgument;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.util.block.BlockUtil;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class CommandTpBiome {
    private static final ExecutorService TP_BIOME_THREAD = Executors.newFixedThreadPool(1);

    static ArgumentBuilder<CommandSource, ?> register() {
        return Commands.func_197057_a((String)"tpbiome").then(Commands.func_197056_a((String)"biome", (ArgumentType)BiomeArgument.createArgument()).executes(ctx -> {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            TP_BIOME_THREAD.execute(() -> {
                try {
                    CommandTpBiome.findTeleportBiome((CommandSource)ctx.getSource(), player, BiomeArgument.getValue((CommandContext<CommandSource>)ctx, "biome"));
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            });
            return 1;
        }));
    }

    private static int findTeleportBiome(CommandSource cs, ServerPlayerEntity player, Biome biome) {
        String biomeName;
        World world = player.field_70170_p;
        BlockPos closestBiomePos = biome == null ? null : BiomeUtil.spiralOutwardsLookingForBiome(world, biome, player.field_70165_t, player.field_70161_v);
        String string = biomeName = biome != null && world.field_72995_K ? biome.func_205403_k().toString() : biome.getRegistryName().toString();
        if (closestBiomePos != null) {
            double x = closestBiomePos.func_177958_n();
            double y = BlockUtil.getTopSolidOrLiquidBlock((IWorld)world, closestBiomePos.func_177958_n(), closestBiomePos.func_177952_p()).func_177956_o();
            double z = closestBiomePos.func_177952_p();
            if (!world.func_201675_m().func_76569_d()) {
                y = CommandTpBiome.getTopBlockNonOverworld(world, closestBiomePos).func_177956_o();
            }
            player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
            cs.func_197030_a((ITextComponent)new TranslationTextComponent("commands.biomesoplenty.tpbiome.success", new Object[]{player.func_200200_C_(), biomeName, x, y, z}), true);
        } else {
            cs.func_197030_a((ITextComponent)new TranslationTextComponent("commands.biomesoplenty.tpbiome.error", new Object[]{biomeName}), true);
        }
        return 1;
    }

    public static BlockPos getTopBlockNonOverworld(World world, BlockPos pos) {
        BlockPos blockpos2;
        IChunk chunk = world.func_217349_x(pos);
        BlockPos blockpos = blockpos2 = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState state = chunk.func_180495_p(blockpos1);
            if (!state.func_185904_a().func_76230_c() && !world.func_175623_d(blockpos1.func_177977_b()) && state.func_185904_a() != Material.field_151584_j) {
                return blockpos1;
            }
            blockpos = blockpos1;
        }
        return blockpos2;
    }
}

