/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.common.util.block.IBlockPosQuery;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class DeadCoralSpikesFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).func_177230_c() == Blocks.field_150377_bs;
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos);
    int minRadius = 2;
    int maxRadius = 5;
    int minHeight = 3;
    int maxHeight = 17;

    public DeadCoralSpikesFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random rand, BlockPos startPos, NoFeatureConfig p_212245_5_) {
        BlockState block;
        int randRadius = this.minRadius + rand.nextInt(this.maxRadius - this.minRadius);
        int height = this.minHeight + rand.nextInt(this.maxHeight - this.minHeight);
        while (startPos.func_177956_o() > 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        for (int x = 0; x <= randRadius - 1; ++x) {
            for (int z = 0; z <= randRadius - 1; ++z) {
                if (this.placeOn.matches(world, startPos.func_177982_a(x, 0, z))) continue;
                return false;
            }
        }
        BlockPos pos = startPos.func_177984_a();
        int randCoral = rand.nextInt(5);
        switch (randCoral) {
            default: {
                block = Blocks.field_204405_jF.func_176223_P();
                break;
            }
            case 1: {
                block = Blocks.field_204406_jG.func_176223_P();
                break;
            }
            case 2: {
                block = Blocks.field_204407_jH.func_176223_P();
                break;
            }
            case 3: {
                block = Blocks.field_204408_jI.func_176223_P();
                break;
            }
            case 4: {
                block = Blocks.field_204404_jE.func_176223_P();
            }
        }
        for (int y = 0; y < height - 1; ++y) {
            int radius = randRadius * (height - y) / height + 1;
            int radiusStart = MathHelper.func_76143_f((double)(0.25 - (double)radius / 2.0));
            int radiusEnd = MathHelper.func_76128_c((double)(0.25 + (double)radius / 2.0));
            for (int x = radiusStart; x <= radiusEnd; ++x) {
                for (int z = radiusStart; z <= radiusEnd; ++z) {
                    if (!this.replace.matches(world, pos.func_177982_a(x, y, z))) continue;
                    this.func_202278_a((IWorldWriter)world, pos.func_177982_a(x, y, z), block);
                }
            }
        }
        return true;
    }
}

