/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.BlockUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public abstract class TreeFeatureBase
extends AbstractTreeFeature<NoFeatureConfig> {
    protected final IBlockPosQuery placeOn;
    protected final IBlockPosQuery replace;
    protected final BlockState log;
    protected final BlockState leaves;
    protected final BlockState altLeaves;
    protected final BlockState vine;
    protected final BlockState hanging;
    protected final BlockState trunkFruit;
    protected final int minHeight;
    protected final int maxHeight;
    protected IProperty logAxisProperty;

    protected TreeFeatureBase(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(NoFeatureConfig::func_214639_a, notify);
        this.placeOn = placeOn;
        this.replace = replace;
        this.log = log;
        this.leaves = leaves;
        this.logAxisProperty = BlockUtil.getAxisProperty(log);
        this.altLeaves = altLeaves;
        this.vine = vine;
        this.hanging = hanging;
        this.trunkFruit = trunkFruit;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public boolean setLeaves(IWorld world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            this.func_202278_a((IWorldWriter)world, pos, this.leaves);
            return true;
        }
        return false;
    }

    public boolean setLog(Set<BlockPos> changedBlocks, IWorld world, BlockPos pos, MutableBoundingBox boundingBox) {
        return this.setLog(changedBlocks, world, pos, null, boundingBox);
    }

    public boolean setLog(Set<BlockPos> changedBlocks, IWorld world, BlockPos pos, Direction.Axis axis, MutableBoundingBox boundingBox) {
        BlockState directedLog;
        BlockState blockState = directedLog = axis != null && this.logAxisProperty != null ? (BlockState)this.log.func_206870_a(this.logAxisProperty, (Comparable)axis) : this.log;
        if (this.replace.matches(world, pos)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)world, pos, directedLog, boundingBox);
            return true;
        }
        return false;
    }

    public boolean setVine(IWorld world, Random rand, BlockPos pos, Direction side, int length) {
        BlockState vineState = this.vine.func_177230_c() instanceof VineBlock ? (BlockState)((BlockState)((BlockState)((BlockState)this.vine.func_206870_a((IProperty)VineBlock.field_176273_b, (Comparable)Boolean.valueOf(side == Direction.NORTH))).func_206870_a((IProperty)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(side == Direction.EAST))).func_206870_a((IProperty)VineBlock.field_176279_N, (Comparable)Boolean.valueOf(side == Direction.SOUTH))).func_206870_a((IProperty)VineBlock.field_176280_O, (Comparable)Boolean.valueOf(side == Direction.WEST)) : this.vine;
        boolean setOne = false;
        while (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockReader)world, pos) && length > 0 && rand.nextInt(12) > 0) {
            this.func_202278_a((IWorldWriter)world, pos, vineState);
            setOne = true;
            --length;
            pos = pos.func_177977_b();
        }
        return setOne;
    }

    public boolean setHanging(IWorld world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            this.func_202278_a((IWorldWriter)world, pos, this.hanging);
        }
        return false;
    }

    public boolean setTrunkFruit(IWorld world, BlockPos pos) {
        if (this.trunkFruit == null) {
            return false;
        }
        if (this.replace.matches(world, pos)) {
            this.func_202278_a((IWorldWriter)world, pos, this.trunkFruit);
        }
        return false;
    }

    public boolean setAltLeaves(IWorld world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            this.func_202278_a((IWorldWriter)world, pos, this.altLeaves);
            return true;
        }
        return false;
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        return this.place(changedBlocks, (IWorld)world, rand, position, boundingBox);
    }

    protected boolean place(Set<BlockPos> changedBlocks, IWorld world, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        return false;
    }

    protected static abstract class BuilderBase<T extends BuilderBase, F extends TreeFeatureBase> {
        protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.field_196674_t));
        protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos) || world.func_180495_p(pos).func_177230_c().func_203417_a(BlockTags.field_200030_g) || world.func_180495_p(pos).func_177230_c() == Blocks.field_150395_bd || world.func_180495_p(pos).func_177230_c() == BOPBlocks.willow_vine || world.func_180495_p(pos).func_177230_c() instanceof BushBlock;
        protected BlockState log = Blocks.field_196617_K.func_176223_P();
        protected BlockState leaves = Blocks.field_196642_W.func_176223_P();
        protected BlockState vine = Blocks.field_150350_a.func_176223_P();
        protected BlockState hanging = Blocks.field_150350_a.func_176223_P();
        protected BlockState trunkFruit = Blocks.field_150350_a.func_176223_P();
        protected BlockState altLeaves = Blocks.field_150350_a.func_176223_P();
        protected int minHeight;
        protected int maxHeight;
        protected boolean updateNeighbours = false;

        public T placeOn(IBlockPosQuery a) {
            this.placeOn = a;
            return (T)this;
        }

        public T replace(IBlockPosQuery a) {
            this.replace = a;
            return (T)this;
        }

        public T log(BlockState a) {
            this.log = a;
            return (T)this;
        }

        public T leaves(BlockState a) {
            this.leaves = a;
            return (T)this;
        }

        public T vine(BlockState a) {
            this.vine = a;
            return (T)this;
        }

        public T hanging(BlockState a) {
            this.hanging = a;
            return (T)this;
        }

        public T trunkFruit(BlockState a) {
            this.trunkFruit = a;
            return (T)this;
        }

        public T altLeaves(BlockState a) {
            this.altLeaves = a;
            return (T)this;
        }

        public T minHeight(int a) {
            this.minHeight = a;
            return (T)this;
        }

        public T maxHeight(int a) {
            this.maxHeight = a;
            return (T)this;
        }

        public T updateNeighbours(boolean a) {
            this.updateNeighbours = a;
            return (T)this;
        }

        abstract F create();
    }
}

