/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.world.SimplexNoise;
import biomesoplenty.common.world.layer.traits.IBOPAreaTransformer0;
import biomesoplenty.common.world.layer.traits.IBOPContextExtended;

public enum GenLayerTemperatureNoise implements IBOPAreaTransformer0
{
    SMALL_ZONES(0.2),
    MEDIUM_ZONES(0.1),
    LARGE_ZONES(0.05);

    private final double scale;

    private GenLayerTemperatureNoise(double scale) {
        this.scale = scale;
    }

    @Override
    public int apply(IBOPContextExtended context, int x, int z) {
        double zOffset;
        double xOffset = (double)(context.getWorldSeed() & 0xFFFFFFL) * 1.0E-6;
        double noiseVal = SimplexNoise.noise(((double)x + xOffset) * this.scale, ((double)z + (zOffset = (double)(context.getWorldSeed() & 0xFFFFFFL) * 2.0E-6)) * this.scale);
        if (noiseVal < -0.619) {
            return 0;
        }
        if (noiseVal < -0.503) {
            return 1;
        }
        if (noiseVal < -0.293) {
            return 2;
        }
        if (noiseVal < -0.12) {
            return 3;
        }
        if (noiseVal < 0.085) {
            return 4;
        }
        if (noiseVal < 0.252) {
            return 5;
        }
        if (noiseVal < 0.467) {
            return 6;
        }
        if (noiseVal < 0.619) {
            return 7;
        }
        return 8;
    }
}

