/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.biome;

import biomesoplenty.api.biome.BiomeOwner;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.biome.generation.GenerationManager;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.TerrainSettings;
import biomesoplenty.common.world.feature.GeneratorFlora;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.ChunkPrimer;

public class BOPBiome
extends BiomeGenBase
implements IExtendedBiome {
    private GenerationManager generationManager = new GenerationManager();
    private Map<BOPClimates, Integer> weightMap = new HashMap<BOPClimates, Integer>();
    public int skyColor = -1;
    public boolean hasBiomeEssence = true;
    public IBlockState seaFloorBlock = Blocks.field_150346_d.func_176223_P();
    public boolean canSpawnInBiome = true;
    public boolean canGenerateVillages = true;
    public boolean canGenerateRivers = true;
    public int beachBiomeId;
    public TerrainSettings terrainSettings;
    public boolean noNeighborTerrainInfuence;
    public int avgDirtDepth;

    public BOPBiome() {
        super(-1, false);
        this.beachBiomeId = BiomeGenBase.field_76787_r.field_76756_M;
        this.terrainSettings = new TerrainSettings();
        this.noNeighborTerrainInfuence = false;
        this.avgDirtDepth = 3;
        this.terrainSettings.setDefaults();
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76801_G = -999;
        this.field_76760_I.field_76805_H = -999;
        this.addGenerator("roots", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).with(BOPPlants.ROOT)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        ArrayList<BOPConfig.IConfigObj> confEntities;
        BOPConfig.IConfigObj confGenerators;
        this.field_76791_y = conf.getString("biomeName", this.field_76791_y);
        this.field_76752_A = conf.getBlockState("topBlock", this.field_76752_A);
        this.field_76753_B = conf.getBlockState("fillerBlock", this.field_76753_B);
        this.seaFloorBlock = conf.getBlockState("seaFloorBlock", this.seaFloorBlock);
        this.field_76748_D = conf.getFloat("rootHeight", Float.valueOf(this.field_76748_D)).floatValue();
        this.field_76749_E = conf.getFloat("variation", Float.valueOf(this.field_76749_E)).floatValue();
        this.field_76750_F = conf.getFloat("temperature", Float.valueOf(this.field_76750_F)).floatValue();
        this.field_76751_G = conf.getFloat("rainfall", Float.valueOf(this.field_76751_G)).floatValue();
        this.field_76790_z = conf.getInt("color", this.field_76790_z);
        this.field_76759_H = conf.getInt("waterColorMultiplier", this.field_76759_H);
        this.field_76765_S = conf.getBool("enableRain", this.field_76765_S);
        this.field_76766_R = conf.getBool("enableSnow", this.field_76766_R);
        this.skyColor = conf.getInt("skyColor", this.skyColor);
        this.hasBiomeEssence = conf.getBool("hasBiomeEssence", this.hasBiomeEssence);
        this.canSpawnInBiome = conf.getBool("canSpawnInBiome", this.canSpawnInBiome);
        this.canGenerateVillages = conf.getBool("canGenerateVillages", this.canGenerateVillages);
        this.canGenerateRivers = conf.getBool("canGenerateRivers", this.canGenerateRivers);
        this.beachBiomeId = conf.getInt("beachBiomeId", this.beachBiomeId);
        BOPConfig.IConfigObj confWeights = conf.getObject("weights");
        if (confWeights != null) {
            for (BOPClimates climate : BOPClimates.values()) {
                Integer weight = confWeights.getInt(climate.name().toLowerCase(), null);
                if (weight == null) continue;
                if (weight < 1) {
                    this.weightMap.remove((Object)climate);
                    continue;
                }
                this.weightMap.put(climate, weight);
            }
        }
        if ((confGenerators = conf.getObject("generators")) != null) {
            for (String name : confGenerators.getKeys()) {
                this.generationManager.configureWith(name, confGenerators.getObject(name));
            }
        }
        if ((confEntities = conf.getObjectArray("entities")) != null) {
            for (BOPConfig.IConfigObj confEntity : confEntities) {
                BiomeGenBase.SpawnListEntry entry;
                String entityName = confEntity.getString("name");
                EnumCreatureType creatureType = confEntity.getEnum("creatureType", EnumCreatureType.class);
                if (entityName == null || creatureType == null) continue;
                Class entityClazz = null;
                for (Map.Entry entry2 : EntityList.field_75625_b.entrySet()) {
                    String entryEntityName = (String)entry2.getKey();
                    if (!entryEntityName.equalsIgnoreCase(entityName)) continue;
                    entityClazz = (Class)entry2.getValue();
                }
                if (entityClazz == null) {
                    confEntity.addMessage("No entity registered called " + entityName);
                    continue;
                }
                if (!creatureType.func_75598_a().isAssignableFrom(entityClazz)) {
                    confEntity.addMessage("Entity " + entityName + " is not of type " + creatureType);
                    continue;
                }
                List spawns = this.func_76747_a(creatureType);
                Integer weight = confEntity.getInt("weight");
                if (weight != null && weight < 1) {
                    Iterator spawnIterator = spawns.iterator();
                    while (spawnIterator.hasNext()) {
                        entry = (BiomeGenBase.SpawnListEntry)spawnIterator.next();
                        if (entry.field_76300_b != entityClazz) continue;
                        spawnIterator.remove();
                    }
                    continue;
                }
                boolean foundIt = false;
                for (BiomeGenBase.SpawnListEntry entry3 : spawns) {
                    if (entry3.field_76300_b != entityClazz) continue;
                    entry3.field_76292_a = confEntity.getInt("weight", entry3.field_76292_a);
                    entry3.field_76301_c = confEntity.getInt("minGroupCount", entry3.field_76301_c);
                    entry3.field_76299_d = confEntity.getInt("maxGroupCount", entry3.field_76299_d);
                    foundIt = true;
                }
                if (foundIt) continue;
                entry = new BiomeGenBase.SpawnListEntry(entityClazz, confEntity.getInt("weight", 10).intValue(), confEntity.getInt("minGroupCount", 4).intValue(), confEntity.getInt("maxGroupCount", 4).intValue());
                spawns.add(entry);
            }
        }
    }

    @Override
    public BiomeOwner getBiomeOwner() {
        return BiomeOwner.BIOMESOPLENTY;
    }

    @Override
    public void addGenerator(String name, GeneratorStage stage, IGenerator generator) {
        this.generationManager.addGenerator(name, stage, generator);
    }

    public IGenerator getGenerator(String name) {
        return this.generationManager.getGenerator(name);
    }

    public void removeGenerator(String name) {
        this.generationManager.removeGenerator(name);
    }

    @Override
    public GenerationManager getGenerationManager() {
        return this.generationManager;
    }

    @Override
    public Map<BOPClimates, Integer> getWeightMap() {
        return this.weightMap;
    }

    @Override
    public void addWeight(BOPClimates climate, int weight) {
        this.weightMap.put(climate, weight);
    }

    @Override
    public void clearWeights() {
        this.weightMap.clear();
    }

    public boolean hasBiomeEssence() {
        return this.hasBiomeEssence;
    }

    public int func_76731_a(float temperature) {
        return this.skyColor == -1 ? super.func_76731_a(temperature) : this.skyColor;
    }

    public BiomeGenBase func_76732_a(float temp, float rain) {
        this.field_76750_F = temp;
        this.field_76751_G = rain;
        return this;
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double stoneNoiseVal) {
        IBlockState topBlock = this.field_76752_A;
        IBlockState fillerBlock = this.field_76753_B;
        IBlockState seaFloorBlock = this.seaFloorBlock;
        boolean hitFloorYet = false;
        int topBlocksToFill = 0;
        int dirtBlocksToFill = 0;
        int seaFloorBlocksToFill = 0;
        int dirtDepth = Math.max(0, (int)(stoneNoiseVal / 3.0 + (double)this.avgDirtDepth + rand.nextDouble() * 0.25));
        int seaFloorDepth = 1 + rand.nextInt(2);
        int localX = x & 0xF;
        int localZ = z & 0xF;
        for (int y = 255; y >= 0; --y) {
            IBlockState state = primer.func_177856_a(localZ, y, localX);
            if (y <= rand.nextInt(5)) {
                primer.func_177855_a(localZ, y, localX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (state.func_177230_c().func_149688_o() == Material.field_151579_a) {
                topBlocksToFill = topBlock == null ? 0 : 1;
                dirtBlocksToFill = dirtDepth;
                continue;
            }
            if (!hitFloorYet && state.func_177230_c().func_149688_o() == Material.field_151586_h) {
                seaFloorBlocksToFill = seaFloorDepth;
            }
            if (state.func_177230_c() != Blocks.field_150348_b) continue;
            hitFloorYet = true;
            if (topBlocksToFill > 0) {
                if (y >= 62) {
                    primer.func_177855_a(localZ, y, localX, topBlock);
                } else if (y >= 56 - dirtDepth) {
                    primer.func_177855_a(localZ, y, localX, fillerBlock);
                } else {
                    primer.func_177855_a(localZ, y, localX, Blocks.field_150351_n.func_176223_P());
                    dirtBlocksToFill = 0;
                }
                --topBlocksToFill;
                continue;
            }
            if (seaFloorBlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, seaFloorBlock);
                --seaFloorBlocksToFill;
                continue;
            }
            if (dirtBlocksToFill <= 0) continue;
            primer.func_177855_a(localZ, y, localX, fillerBlock);
            if (--dirtBlocksToFill != 0 || fillerBlock.func_177230_c() != Blocks.field_150354_m) continue;
            dirtBlocksToFill = rand.nextInt(4) + Math.max(0, y - 63);
            fillerBlock = fillerBlock.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
        }
    }

    @Override
    public int getBeachId() {
        return this.beachBiomeId;
    }

    @Override
    public BiomeGenBase getBaseBiome() {
        return this;
    }
}

