/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.biome.generation;

import biomesoplenty.api.biome.generation.GeneratorRegistry;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.common.util.config.BOPConfig;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GenerationManager {
    private Map<String, IGenerator> generators = new HashMap<String, IGenerator>();

    public void addGenerator(String name, GeneratorStage stage, IGenerator generator) {
        if (this.generators.containsKey(name)) {
            throw new RuntimeException("A generator with name " + name + " already exists!");
        }
        generator.setName(name);
        generator.setStage(stage);
        this.generators.put(name, generator);
    }

    public ImmutableCollection<IGenerator> getGeneratorsForStage(GeneratorStage stage) {
        ArrayList<IGenerator> out = new ArrayList<IGenerator>();
        for (IGenerator generator : this.generators.values()) {
            if (generator.getStage() != stage) continue;
            out.add(generator);
        }
        return ImmutableList.copyOf(out);
    }

    public void removeGenerator(String name) {
        this.generators.remove(name);
    }

    public IGenerator getGenerator(String name) {
        return this.generators.get(name);
    }

    public void configureWith(String name, BOPConfig.IConfigObj conf) {
        if (this.generators.containsKey(name)) {
            if (conf.getBool("enable", true).booleanValue()) {
                this.generators.get(name).configure(conf);
            } else {
                this.generators.remove(name);
            }
        } else {
            IGenerator generator = GeneratorRegistry.createGenerator(conf);
            if (generator != null) {
                this.generators.put(name, generator);
            }
        }
    }
}

