/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorBlobs;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.GeneratorSplatter;
import biomesoplenty.common.world.feature.GeneratorSplotches;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenColdDesert
extends BOPBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeGenColdDesert() {
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.terrainSettings.avgHeight(64.0).heightVariation(5.0, 10.0).sidewaysNoise(0.7);
        this.field_76752_A = Blocks.field_150351_n.func_176223_P();
        this.field_76753_B = Blocks.field_150348_b.func_176223_P();
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = Blocks.field_150433_aE.func_176223_P();
        this.canGenerateRivers = false;
        this.func_76745_m();
        this.field_76766_R = false;
        this.func_76732_a(0.0f, 0.0f);
        this.addWeight(BOPClimates.ICE_CAP, 10);
        this.func_76739_b(11775899);
        this.field_76762_K.clear();
        BlockQuery.BlockQueryBlock surface = new BlockQuery.BlockQueryBlock(Blocks.field_150348_b, Blocks.field_150351_n);
        this.addGenerator("stone_patches", GeneratorStage.SAND, ((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)new GeneratorSplotches.Builder().amountPerChunk(6.0f)).splotchSize(24).placeOn(surface)).replace(surface)).with(Blocks.field_150348_b.func_176223_P())).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).create());
        this.addGenerator("boulders", GeneratorStage.SAND_PASS2, ((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)new GeneratorBlobs.Builder().amountPerChunk(0.2f)).placeOn(surface)).with(Blocks.field_150347_e.func_176223_P())).minRadius(0.3f).maxRadius(3.2f).numBalls(4).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).create());
        this.addGenerator("hard_ice_splatter", GeneratorStage.SAND, ((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)new GeneratorSplatter.Builder().amountPerChunk(1.0f)).replace(surface)).with(BOPBlocks.hard_ice.func_176223_P())).create());
        this.addGenerator("tanzanite", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.TANZANITE)).create());
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("tanzanite");
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        this.field_76752_A = noise + rand.nextDouble() * 3.0 > 1.8 ? this.alternateTopBlock : this.usualTopBlock;
        super.func_180622_a(world, rand, primer, x, z, noise);
    }
}

