/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.common.entities.EntityButterfly;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPFlowers;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorDoubleFlora;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.tree.GeneratorBush;
import biomesoplenty.common.world.feature.tree.GeneratorProfileTree;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.util.BlockPos;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeGenGrove
extends BOPBiome {
    public BiomeGenGrove() {
        this.terrainSettings.avgHeight(66.0).heightVariation(8.0, 20.0).octaves(0.0, 1.0, 2.0, 2.0, 1.0, 0.0).sidewaysNoise(0.1);
        this.func_76739_b(5341009);
        this.func_76732_a(0.55f, 0.8f);
        this.addWeight(BOPClimates.COOL_TEMPERATE, 7);
        this.canGenerateVillages = true;
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityButterfly.class, 6, 2, 4));
        this.addGenerator("sprouts", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.SPROUT)).create());
        this.addGenerator("berry_bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(BOPPlants.BERRYBUSH)).create());
        this.addGenerator("bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.4f)).with(BOPPlants.BUSH)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("clover_patches", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.6f)).with(BOPPlants.CLOVERPATCH)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.LEAFPILE)).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("dark_poplar", 1, ((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)new GeneratorProfileTree.Builder().minHeight(6)).maxHeight(14)).log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).profile(GeneratorProfileTree.TreeProfile.POPLAR).create());
        treeGenerator.add("poplar", 1, ((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)new GeneratorProfileTree.Builder().minHeight(8)).maxHeight(18)).log(BlockPlanks.EnumType.BIRCH)).leaves(BlockPlanks.EnumType.BIRCH)).profile(GeneratorProfileTree.TreeProfile.POPLAR).create());
        treeGenerator.add("bush", 1, ((GeneratorBush.Builder)((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).altLeaves(BOPTrees.FLOWERING)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(3.0f);
        this.addGenerator("flowers", GeneratorStage.GRASS, flowerGenerator);
        flowerGenerator.add("clover", 4, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.CLOVER)).create());
        flowerGenerator.add("white_anemones", 2, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.WHITE_ANEMONE)).create());
        flowerGenerator.add("paeonias", 1, new GeneratorDoubleFlora.Builder().with(BlockDoublePlant.EnumPlantType.PAEONIA).create());
        flowerGenerator.add("oxeye_daisy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.OXEYE_DAISY)).create());
        flowerGenerator.add("dandelion", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("poppy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(9.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("amber", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.AMBER)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("amber");
        }
        if (!settings.generateBerryBushes) {
            this.removeGenerator("berry_bushes");
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.generateBopWaterPlants) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.generateBopTrees) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("dark_poplar", 1, ((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)new GeneratorProfileTree.Builder().minHeight(6)).maxHeight(14)).log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).profile(GeneratorProfileTree.TreeProfile.POPLAR).create());
            treeGenerator.add("poplar", 1, ((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)((GeneratorProfileTree.Builder)new GeneratorProfileTree.Builder().minHeight(8)).maxHeight(18)).log(BlockPlanks.EnumType.BIRCH)).leaves(BlockPlanks.EnumType.BIRCH)).profile(GeneratorProfileTree.TreeProfile.POPLAR).create());
            treeGenerator.add("bush", 1, ((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).create());
        }
        GeneratorWeighted flowerGen = (GeneratorWeighted)this.getGenerator("flowers");
        if (!settings.generateBopFlowers) {
            flowerGen.removeGenerator("bluebells");
            flowerGen.removeGenerator("clover");
            flowerGen.removeGenerator("swampflower");
            flowerGen.removeGenerator("deathbloom");
            flowerGen.removeGenerator("glowflower");
            flowerGen.removeGenerator("blue_hydrangeas");
            flowerGen.removeGenerator("pink_daffodil");
            flowerGen.removeGenerator("white_anemones");
            flowerGen.removeGenerator("orange_cosmos");
            flowerGen.removeGenerator("wildflowers");
            flowerGen.removeGenerator("violet");
            flowerGen.removeGenerator("hibiscus");
            flowerGen.removeGenerator("goldenrods");
            flowerGen.removeGenerator("icy_irises");
            flowerGen.removeGenerator("wilted_lily");
            flowerGen.removeGenerator("lily_of_the_valley");
            flowerGen.removeGenerator("bromeliad");
            this.removeGenerator("bromeliad");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return noise < -0.1 ? 5341009 : 6331992;
    }

    public int func_180625_c(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return noise < -0.1 ? 0x619961 : 7714153;
    }
}

