/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPFlowers;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.enums.BOPWoods;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.GeneratorWaterside;
import biomesoplenty.common.world.feature.tree.GeneratorBasicTree;
import biomesoplenty.common.world.feature.tree.GeneratorBigTree;
import biomesoplenty.common.world.feature.tree.GeneratorBush;
import biomesoplenty.common.world.feature.tree.GeneratorPineTree;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeGenHeathland
extends BOPBiome {
    public BiomeGenHeathland() {
        this.terrainSettings.avgHeight(75.0).heightVariation(7.0, 10.0).octaves(0.0, 1.0, 2.0, 2.0, 1.0, 0.0).sidewaysNoise(0.1);
        this.func_76739_b(11382376);
        this.func_76732_a(0.75f, 0.2f);
        this.addWeight(BOPClimates.DRY_TEMPERATE, 5);
        this.canGenerateVillages = true;
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityHorse.class, 1, 2, 6));
        this.addGenerator("sand", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(3.0f)).maxRadius(7).with(Blocks.field_150354_m.func_176223_P())).create());
        this.addGenerator("gravel", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(4.0f)).maxRadius(7).with(Blocks.field_150351_n.func_176223_P())).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(3.0f);
        this.addGenerator("flowers", GeneratorStage.GRASS, flowerGenerator);
        flowerGenerator.add("wildflower", 7, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.WILDFLOWER)).create());
        flowerGenerator.add("dandelion", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("allium", 4, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.ALLIUM)).create());
        flowerGenerator.add("poppy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(6.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        BlockQuery.IBlockPosQuery suitableTreePosition = BlockQuery.buildAnd().withAltitudeBetween(77, 90).materials(Material.field_151578_c, Material.field_151577_b).create();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(12.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("red_bush", 7, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().placeOn(this.field_76752_A)).replace(Material.field_151579_a)).withNonDecayingLeaf(BOPTrees.MAPLE)).create());
        treeGenerator.add("small_bush", 11, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().placeOn(this.field_76752_A)).replace(Material.field_151579_a)).withNonDecayingLeaf(BlockPlanks.EnumType.OAK)).create());
        treeGenerator.add("oak_bush", 3, ((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).create());
        treeGenerator.add("oak", 2, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().minHeight(3)).maxHeight(5)).create());
        treeGenerator.add("decaying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().amountPerChunk(1.0f)).minHeight(5)).maxHeight(12)).foliageHeight(2).create());
        treeGenerator.add("pine", 15, ((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)new GeneratorPineTree.Builder().minHeight(6)).maxHeight(18)).log(BOPWoods.PINE)).leaves(BOPTrees.PINE)).placeOn(suitableTreePosition)).create());
        this.addGenerator("thorns", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.4f)).with(BOPPlants.THORN)).create());
        this.addGenerator("bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.5f)).with(BOPPlants.BUSH)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(BOPPlants.LEAFPILE)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.DEADLEAFPILE)).create());
        this.addGenerator("water_reeds", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.REED)).generationAttempts(32)).create());
        this.addGenerator("desertgrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(6.0f)).with(BOPPlants.DESERTGRASS)).create());
        this.addGenerator("peridot", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.PERIDOT)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("peridot");
        }
        if (!settings.generateThorns) {
            this.removeGenerator("thorns");
        }
        if (!settings.generateBopSoils) {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.generateBopWaterPlants) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.generateBopTrees) {
            this.removeGenerator("trees");
            BlockQuery.IBlockPosQuery suitableTreePosition = BlockQuery.buildAnd().withAltitudeBetween(77, 90).materials(Material.field_151578_c, Material.field_151577_b).create();
            GeneratorWeighted treeGenerator = new GeneratorWeighted(12.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("red_bush", 7, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().placeOn(this.field_76752_A)).replace(Material.field_151579_a)).withNonDecayingLeaf(BlockPlanks.EnumType.BIRCH)).create());
            treeGenerator.add("small_bush", 11, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().placeOn(this.field_76752_A)).replace(Material.field_151579_a)).withNonDecayingLeaf(BlockPlanks.EnumType.OAK)).create());
            treeGenerator.add("oak_bush", 3, ((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).create());
            treeGenerator.add("oak", 2, ((GeneratorBasicTree.Builder)((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().minHeight(3)).maxHeight(5)).create());
            treeGenerator.add("decaying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().amountPerChunk(1.0f)).minHeight(5)).maxHeight(12)).foliageHeight(2).create());
            treeGenerator.add("pine", 15, ((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)new GeneratorPineTree.Builder().minHeight(6)).maxHeight(18)).log(BlockPlanks.EnumType.SPRUCE)).leaves(BlockPlanks.EnumType.SPRUCE)).placeOn(suitableTreePosition)).create());
        }
        GeneratorWeighted flowerGen = (GeneratorWeighted)this.getGenerator("flowers");
        if (!settings.generateBopFlowers) {
            flowerGen.removeGenerator("bluebells");
            flowerGen.removeGenerator("clover");
            flowerGen.removeGenerator("swampflower");
            flowerGen.removeGenerator("deathbloom");
            flowerGen.removeGenerator("glowflower");
            flowerGen.removeGenerator("blue_hydrangeas");
            flowerGen.removeGenerator("pink_daffodil");
            flowerGen.removeGenerator("white_anemones");
            flowerGen.removeGenerator("orange_cosmos");
            flowerGen.removeGenerator("wildflowers");
            flowerGen.removeGenerator("violet");
            flowerGen.removeGenerator("hibiscus");
            flowerGen.removeGenerator("goldenrods");
            flowerGen.removeGenerator("icy_irises");
            flowerGen.removeGenerator("wilted_lily");
            flowerGen.removeGenerator("lily_of_the_valley");
            flowerGen.removeGenerator("bromeliad");
            this.removeGenerator("bromeliad");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
            this.removeGenerator("desertgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return noise < -0.1 ? 11378024 : 11382376;
    }

    public int func_180625_c(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return noise < -0.1 ? 11970403 : 11978339;
    }
}

