/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorBlobs;
import biomesoplenty.common.world.feature.GeneratorDoubleFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.init.Blocks;

public class BiomeGenHighland
extends BOPBiome {
    public BiomeGenHighland() {
        this.terrainSettings.avgHeight(120.0).heightVariation(25.0, 25.0);
        this.func_76739_b(8170854);
        this.func_76732_a(0.55f, 0.8f);
        this.canGenerateRivers = false;
        this.canGenerateVillages = false;
        this.addWeight(BOPClimates.COOL_TEMPERATE, 7);
        this.beachBiomeId = -1;
        this.addGenerator("boulders", GeneratorStage.SAND, ((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)new GeneratorBlobs.Builder().amountPerChunk(0.5f)).placeOn((Block)Blocks.field_150349_c)).with(Blocks.field_150347_e.func_176223_P())).minRadius(0.3f).maxRadius(1.2f).numBalls(1).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).create());
        this.addGenerator("big_boulders", GeneratorStage.SAND, ((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)new GeneratorBlobs.Builder().amountPerChunk(0.1f)).placeOn((Block)Blocks.field_150349_c)).with(Blocks.field_150347_e.func_176223_P())).minRadius(0.3f).maxRadius(4.0f).numBalls(3).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(10.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        grassGenerator.add("doublegrass", 4, new GeneratorDoubleFlora.Builder().with(BlockDoublePlant.EnumPlantType.GRASS).create());
        this.addGenerator("emerald", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(Blocks.field_150412_bA.func_176223_P())).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }
}

