/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPSand;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.enums.BOPWoods;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorLakes;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.tree.GeneratorMangroveTree;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenMangrove
extends BOPBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeGenMangrove() {
        this.func_76739_b(7251289);
        this.func_76732_a(0.8f, 0.3f);
        this.field_76759_H = 13500241;
        this.terrainSettings.avgHeight(62.0).heightVariation(2.0, 4.0).octaves(0.0, 1.0, 2.0, 2.0, 1.0, 0.0);
        this.seaFloorBlock = BOPBlocks.mud.func_176223_P();
        this.field_76752_A = BOPBlocks.mud.func_176223_P();
        this.field_76753_B = BOPBlocks.mud.func_176223_P();
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = Blocks.field_150354_m.func_176223_P();
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.field_76762_K.clear();
        this.beachBiomeId = -1;
        this.clearWeights();
        this.addGenerator("quicksand", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.2f)).waterLakeForBiome(this).liquid(BOPBlocks.sand.func_176223_P().func_177226_a((IProperty)BlockBOPSand.VARIANT, (Comparable)((Object)BlockBOPSand.SandType.QUICKSAND))).frozenLiquid((IBlockState)null).create());
        BlockQuery.IBlockPosQuery emptySandMud = BlockQuery.buildAnd().states(this.usualTopBlock).create();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(7.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("mangrove", 1, ((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)new GeneratorMangroveTree.Builder().placeOn(emptySandMud)).log(BOPWoods.MANGROVE)).leaves(BOPTrees.MANGROVE)).create());
        this.addGenerator("sapphire", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.SAPPHIRE)).create());
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        double d0 = field_180281_af.func_151601_a((double)x * 0.25, (double)z * 0.25);
        if (d0 > 0.0) {
            int i = x & 0xF;
            int j = z & 0xF;
            for (int k = 255; k >= 0; --k) {
                if (primer.func_177856_a(j, k, i).func_177230_c().func_149688_o() == Material.field_151579_a) continue;
                if (k != 62 || primer.func_177856_a(j, k, i).func_177230_c() == Blocks.field_150355_j) break;
                primer.func_177855_a(j, k, i, Blocks.field_150355_j.func_176223_P());
                break;
            }
        }
        this.field_76752_A = noise + rand.nextDouble() * 1.0 > 1.8 ? this.alternateTopBlock : this.usualTopBlock;
        this.func_180628_b(world, rand, primer, x, z, noise);
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("sapphire");
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
    }
}

