/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.enums.BOPWoods;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorDoubleFlora;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorLakes;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.GeneratorSplotches;
import biomesoplenty.common.world.feature.GeneratorWaterside;
import biomesoplenty.common.world.feature.tree.GeneratorBasicTree;
import biomesoplenty.common.world.feature.tree.GeneratorPineTree;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenMountain
extends BOPBiome {
    public MountainType type;
    public IBlockState grassBlock;
    public IBlockState dirtBlock;
    public IBlockState coarseDirtBlock;
    public IBlockState stoneBlock;

    public BiomeGenMountain(MountainType type) {
        this.type = type;
        this.canSpawnInBiome = false;
        switch (type) {
            case PEAKS: {
                this.terrainSettings.avgHeight(140.0).heightVariation(30.0, 60.0).octaves(1.0, 1.0, 2.0, 2.0, 3.0, 3.0).sidewaysNoise(0.1);
                break;
            }
            case FOOTHILLS: {
                this.terrainSettings.avgHeight(100.0).heightVariation(15.0, 30.0).octaves(0.0, 1.0, 1.0, 3.0, 1.0, 0.0).sidewaysNoise(0.1);
            }
        }
        this.canGenerateRivers = false;
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.func_76739_b(8430421);
        this.func_76732_a(0.8f, 0.1f);
        this.beachBiomeId = -1;
        if (type == MountainType.PEAKS) {
            this.canGenerateVillages = false;
            this.addWeight(BOPClimates.DRY_TEMPERATE, 3);
            this.field_76762_K.clear();
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntitySheep.class, 12, 4, 6));
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 4, 4, 4));
        }
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        this.grassBlock = this.field_76752_A;
        this.dirtBlock = this.field_76753_B;
        this.coarseDirtBlock = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
        this.stoneBlock = Blocks.field_150348_b.func_176223_P();
        this.addGenerator("gravel", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(6.0f)).maxRadius(7).with(Blocks.field_150351_n.func_176223_P())).create());
        this.addGenerator("gravel_patches", GeneratorStage.SAND_PASS2, ((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)new GeneratorSplotches.Builder().amountPerChunk(2.0f)).splotchSize(16).replace(this.field_76752_A)).with(Blocks.field_150351_n.func_176223_P())).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).create());
        this.addGenerator("lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(1.8f)).waterLakeForBiome(this).create());
        BlockQuery.IBlockPosQuery suitableTreePosition = BlockQuery.buildAnd().withAltitudeBetween(64, 140).materials(Material.field_151578_c, Material.field_151577_b).create();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("pine", 2, ((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)new GeneratorPineTree.Builder().minHeight(6)).maxHeight(18)).log(BOPWoods.PINE)).leaves(BOPTrees.PINE)).placeOn(suitableTreePosition)).create());
        treeGenerator.add("oak", 1, new GeneratorBasicTree.Builder().create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(5.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).generationAttempts(128)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).generationAttempts(128)).create());
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).generationAttempts(128)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).generationAttempts(128)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).generationAttempts(128)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(BOPPlants.SHRUB)).generationAttempts(type == MountainType.FOOTHILLS ? 64 : 32)).create());
        this.addGenerator("ferns", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(2.0f)).with(BlockTallGrass.EnumType.FERN)).generationAttempts(type == MountainType.FOOTHILLS ? 64 : 32)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.8f)).with(BOPPlants.LEAFPILE)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.2f)).with(BOPPlants.DEADLEAFPILE)).create());
        if (type == MountainType.FOOTHILLS) {
            this.addGenerator("flax", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPDoublePlant.DoublePlantType.FLAX).create());
            this.addGenerator("berry_bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).with(BOPPlants.BERRYBUSH)).create());
            this.addGenerator("water_reeds", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.4f)).with(BOPPlants.REED)).generationAttempts(32)).create());
        }
        this.addGenerator("emeralds", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(Blocks.field_150412_bA.func_176223_P())).create());
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        super.configure(conf);
        this.grassBlock = this.field_76752_A;
        this.dirtBlock = this.field_76753_B;
        this.coarseDirtBlock = conf.getBlockState("coarseDirtBlock", this.coarseDirtBlock);
        this.stoneBlock = conf.getBlockState("stoneBlock", this.stoneBlock);
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateFlax) {
            this.removeGenerator("flax");
        }
        if (!settings.generateBerryBushes) {
            this.removeGenerator("berry_bushes");
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.generateBopWaterPlants) {
            this.removeGenerator("algae");
            this.removeGenerator("water_reeds");
            this.removeGenerator("medium_lily");
            this.removeGenerator("small_lily");
            this.removeGenerator("tiny_lily");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.generateBopTrees) {
            this.removeGenerator("trees");
            BlockQuery.IBlockPosQuery suitableTreePosition = BlockQuery.buildAnd().withAltitudeBetween(64, 140).materials(Material.field_151578_c, Material.field_151577_b).create();
            GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("pine", 2, ((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)((GeneratorPineTree.Builder)new GeneratorPineTree.Builder().minHeight(6)).maxHeight(18)).log(BlockPlanks.EnumType.SPRUCE)).leaves(BlockPlanks.EnumType.SPRUCE)).placeOn(suitableTreePosition)).create());
            treeGenerator.add("oak", 1, new GeneratorBasicTree.Builder().create());
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        int height;
        int localX = x & 0xF;
        int localZ = z & 0xF;
        for (height = 255; height > 0 && primer.func_177856_a(localX, height, localZ).func_177230_c().func_149688_o() == Material.field_151579_a; --height) {
        }
        int peakLine = 140 + (int)(noise * 5.0);
        if (height > peakLine) {
            if (noise > 1.7) {
                this.field_76752_A = this.stoneBlock;
                this.field_76753_B = this.stoneBlock;
            } else {
                this.field_76752_A = this.grassBlock;
                this.field_76753_B = this.dirtBlock;
            }
        } else if (noise < -1.4) {
            this.field_76752_A = this.coarseDirtBlock;
            this.field_76753_B = this.coarseDirtBlock;
        } else if (this.type == MountainType.PEAKS && noise > 1.7) {
            this.field_76752_A = this.stoneBlock;
            this.field_76753_B = this.stoneBlock;
        } else {
            this.field_76752_A = this.grassBlock;
            this.field_76753_B = this.dirtBlock;
        }
        super.func_180622_a(world, rand, primer, x, z, noise);
    }

    public static enum MountainType {
        PEAKS,
        FOOTHILLS;

    }
}

