/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorColumns;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorGrass;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.GeneratorSplatter;
import biomesoplenty.common.world.feature.tree.GeneratorBush;
import biomesoplenty.common.world.feature.tree.GeneratorTwigletTree;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;

public class BiomeGenOutback
extends BOPBiome {
    public BiomeGenOutback() {
        this.terrainSettings.avgHeight(72.0).heightVariation(8.0, 10.0).octaves(0.0, 1.0, 2.0, 1.0, 0.0, 2.0);
        this.func_76732_a(1.5f, 0.05f);
        this.func_76739_b(10843716);
        this.field_76752_A = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
        this.field_76753_B = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
        this.addWeight(BOPClimates.HOT_DESERT, 7);
        this.canGenerateVillages = true;
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        BlockQuery.IBlockPosQuery emptyRedSand = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
        this.addGenerator("grass_splatter", GeneratorStage.SAND, ((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)new GeneratorSplatter.Builder().amountPerChunk(8.0f)).generationAttempts(128).replace(emptyRedSand)).with(BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SANDY)))).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("acacia_bush", 1, ((GeneratorBush.Builder)((GeneratorBush.Builder)((GeneratorBush.Builder)new GeneratorBush.Builder().log(BlockPlanks.EnumType.ACACIA)).leaves(BlockPlanks.EnumType.ACACIA)).maxHeight(2)).create());
        treeGenerator.add("acacia_twiglet", 1, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().minHeight(2)).maxHeight(2)).log(BlockPlanks.EnumType.ACACIA)).leaves(BlockPlanks.EnumType.ACACIA)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(16.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("wheatgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.WHEATGRASS)).create());
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("tiny_cacti", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(BOPPlants.TINYCACTUS)).create());
        this.addGenerator("dead_bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(2.0f)).with(Blocks.field_150330_I.func_176223_P())).create());
        this.addGenerator("cacti", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(0.5f)).generationAttempts(24).placeOn(this.field_76752_A)).with(Blocks.field_150434_aF.func_176223_P())).minHeight(1).maxHeight(2).create());
        this.addGenerator("desertgrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(10.0f)).with(BOPPlants.DESERTGRASS)).generationAttempts(8)).create());
        this.addGenerator("ruby", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.RUBY)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("ruby");
        }
        BlockQuery.IBlockPosQuery emptyRedSand = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
        if (!settings.generateBopSoils) {
            this.removeGenerator("grass_splatter");
            this.addGenerator("grass_splatter_new", GeneratorStage.SAND, ((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)new GeneratorSplatter.Builder().amountPerChunk(8.0f)).generationAttempts(128).replace(emptyRedSand)).with(Blocks.field_150349_c.func_176223_P())).create());
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.generateBopGrasses) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
            this.removeGenerator("desertgrass");
        }
    }
}

