/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.GeneratorWeighted;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.enums.BOPClimates;
import biomesoplenty.common.enums.BOPFlowers;
import biomesoplenty.common.enums.BOPGems;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.enums.BOPTrees;
import biomesoplenty.common.enums.BOPWoods;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.feature.GeneratorFlora;
import biomesoplenty.common.world.feature.GeneratorLakes;
import biomesoplenty.common.world.feature.GeneratorOreSingle;
import biomesoplenty.common.world.feature.tree.GeneratorBigTree;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;

public class BiomeGenWasteland
extends BOPBiome {
    public BiomeGenWasteland() {
        this.terrainSettings.avgHeight(66.0).heightVariation(1.0, 5.0);
        this.func_76739_b(5919808);
        this.func_76732_a(2.0f, 0.0f);
        this.field_76752_A = BOPBlocks.dried_sand.func_176223_P();
        this.field_76753_B = BOPBlocks.dried_sand.func_176223_P();
        this.field_76759_H = 15073024;
        this.skyColor = 9477744;
        this.func_76745_m();
        this.seaFloorBlock = BOPBlocks.dried_sand.func_176223_P();
        this.canGenerateRivers = false;
        this.canGenerateVillages = false;
        this.canSpawnInBiome = false;
        this.beachBiomeId = -1;
        this.addWeight(BOPClimates.WASTELAND, 50);
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        BlockQuery.IBlockPosQuery emptyDriedSand = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(0.3f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("dead_tree", 3, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().placeOn(emptyDriedSand)).minHeight(5)).maxHeight(12)).foliageHeight(0).foliageDensity(0.5).log(BOPWoods.DEAD)).leaves(Blocks.field_150350_a.func_176223_P())).create());
        treeGenerator.add("dying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().placeOn(emptyDriedSand)).minHeight(5)).maxHeight(12)).foliageHeight(1).log(BOPWoods.DEAD)).leaves(BOPTrees.DEAD)).create());
        this.addGenerator("dead_grass", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(BOPPlants.DEADGRASS)).create());
        this.addGenerator("desertgrass", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.DESERTGRASS)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.05f);
        this.addGenerator("flowers", GeneratorStage.GRASS, flowerGenerator);
        flowerGenerator.add("wilted_lily", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.WILTED_LILY)).create());
        this.addGenerator("lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.05f)).waterLakeForBiome(this).create());
        this.addGenerator("poison_lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.05f)).waterLakeForBiome(this).liquid(BOPBlocks.poison).frozenLiquid((IBlockState)null).create());
        this.addGenerator("malachite", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.MALACHITE)).create());
    }

    @Override
    public void applySettings(BOPWorldSettings settings) {
        if (!settings.generateBopGems) {
            this.removeGenerator("malachite");
        }
        if (!settings.generateLiquidPoison) {
            this.removeGenerator("poison_lakes");
        }
        if (!settings.generateBopPlants) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.generateBopFoliage) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.generateBopFlowers) {
            this.removeGenerator("flowers");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.generateBopTrees) {
            this.removeGenerator("trees");
            BlockQuery.IBlockPosQuery emptyDriedSand = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
            GeneratorWeighted treeGenerator = new GeneratorWeighted(0.3f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("dead_tree", 3, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().placeOn(emptyDriedSand)).minHeight(5)).maxHeight(12)).foliageHeight(0).foliageDensity(0.5).log(BlockPlanks.EnumType.OAK)).leaves(Blocks.field_150350_a.func_176223_P())).create());
            treeGenerator.add("dying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().placeOn(emptyDriedSand)).minHeight(5)).maxHeight(12)).foliageHeight(1).log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).create());
        }
        if (!settings.generateBopGrasses) {
            this.removeGenerator("dead_grass");
            this.removeGenerator("desertgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 10330232;
    }

    public int func_180625_c(BlockPos pos) {
        return 0x999E55;
    }

    public int getFogColour(BlockPos pos) {
        return 12106885;
    }

    public float getFogDensity(BlockPos pos) {
        return 0.3f;
    }
}

