/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.block.BlockBOPGrass;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPBamboo
extends BlockBOPDecoration {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{AGE});
    }

    public BlockBOPBamboo() {
        super(Material.field_151575_d);
        this.func_149711_c(0.2f);
        this.func_149672_a(Block.field_149766_f);
        this.setBlockBoundsByRadiusAndHeight(0.1875f, 1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return direction == EnumFacing.UP && plantable.getPlant(world, pos.func_177972_a(direction)).func_177230_c() == this;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState groundState = world.func_180495_p(pos.func_177977_b());
        Block groundBlock = groundState.func_177230_c();
        if (groundBlock == this) {
            return true;
        }
        if (groundBlock == Blocks.field_150346_d || groundBlock == Blocks.field_150458_ak || groundBlock == BOPBlocks.farmland_0 || groundBlock == BOPBlocks.farmland_1 || groundBlock == BOPBlocks.dirt || groundBlock == Blocks.field_150349_c) {
            return true;
        }
        if (groundBlock instanceof BlockBOPGrass) {
            switch ((BlockBOPGrass.BOPGrassType)((Object)groundState.func_177229_b((IProperty)BlockBOPGrass.VARIANT))) {
                case LOAMY: 
                case SANDY: 
                case SILTY: {
                    return true;
                }
            }
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB((double)pos.func_177958_n() + this.field_149759_B, (double)pos.func_177956_o() + this.field_149760_C, (double)pos.func_177952_p() + this.field_149754_D, (double)pos.func_177958_n() + this.field_149755_E, (double)pos.func_177956_o() + this.field_149756_F, (double)pos.func_177952_p() + this.field_149757_G);
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.checkAndDropBlock(worldIn, pos, state) && worldIn.func_175623_d(pos.func_177984_a())) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            int treeHeight = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(treeHeight)).func_177230_c() == this) {
                ++treeHeight;
            }
            if (treeHeight < 4) {
                if (age == 15) {
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        this.setBlockBoundsByRadiusAndHeight(0.2f, 1.0f);
    }

    public boolean canSustainLeaves(IBlockAccess world, BlockPos pos) {
        return true;
    }
}

