/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.IBOPBlock;
import biomesoplenty.common.item.ItemBOPBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPBones
extends Block
implements IBOPBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", BoneType.class);
    public static final PropertyEnum AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{AXIS, VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public int getItemRenderColor(IBlockState state, int tintIndex) {
        return this.func_180644_h(state);
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((BoneType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l() + "_bone_segment";
    }

    public ItemStack getVariantItem(BoneType type) {
        return this.getVariantItem(type, 1);
    }

    public ItemStack getVariantItem(BoneType type, int howMany) {
        return new ItemStack((Block)this, howMany, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)type))));
    }

    public BlockBOPBones() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)VARIANT, (Comparable)((Object)BoneType.LARGE)));
    }

    public IBlockState func_176203_a(int meta) {
        int axis = meta % 3;
        int type = (meta - axis) / 3;
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BoneType.values()[type])).func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.Axis.values()[axis]);
    }

    public int func_176201_c(IBlockState state) {
        int baseMeta = ((BoneType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        return baseMeta * 3 + ((EnumFacing.Axis)state.func_177229_b((IProperty)AXIS)).ordinal();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int metadata, EntityLivingBase entity) {
        return super.func_180642_a(world, pos, side, hitX, hitY, hitZ, metadata, entity).func_177226_a((IProperty)AXIS, (Comparable)side.func_176740_k());
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)VARIANT, state.func_177229_b((IProperty)VARIANT)));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180646_a(worldIn, pos);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180640_a(worldIn, pos, state);
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        float width;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return;
        }
        switch ((BoneType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SMALL: {
                width = 0.25f;
                break;
            }
            case MEDIUM: {
                width = 0.625f;
                break;
            }
            case LARGE: {
                width = 1.0f;
                break;
            }
            default: {
                width = 1.0f;
            }
        }
        float min = (1.0f - width) / 2.0f;
        float max = 1.0f - min;
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)AXIS)) {
            case X: {
                this.func_149676_a(0.0f, min, min, 1.0f, max, max);
                break;
            }
            case Y: {
                this.func_149676_a(min, 0.0f, min, max, 1.0f, max);
                break;
            }
            case Z: {
                this.func_149676_a(min, min, 0.0f, max, max, 1.0f);
            }
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public static enum BoneType implements IStringSerializable
    {
        SMALL,
        MEDIUM,
        LARGE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

