/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.IBOPBlock;
import biomesoplenty.common.item.ItemBOPBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPDecoration
extends Block
implements IBOPBlock {
    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public int getItemRenderColor(IBlockState state, int tintIndex) {
        return this.func_180644_h(state);
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[0];
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return "";
    }

    public BlockBOPDecoration() {
        this(Material.field_151585_k);
    }

    public BlockBOPDecoration(Material material) {
        super(material);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public void setBlockBoundsByRadiusAndHeight(float radius, float height) {
        this.setBlockBoundsByRadiusAndHeight(radius, height, false);
    }

    public void setBlockBoundsByRadiusAndHeight(float radius, float height, boolean fromTop) {
        this.func_149676_a(0.5f - radius, fromTop ? 1.0f - height : 0.0f, 0.5f - radius, 0.5f + radius, fromTop ? 1.0f : height, 0.5f + radius);
    }

    public void setBlockBoundsByRadiusAndHeightWithXZOffset(float radius, float height, BlockPos pos) {
        this.setBlockBoundsByRadiusAndHeightWithXZOffset(radius, height, false, pos);
    }

    public void setBlockBoundsByRadiusAndHeightWithXZOffset(float radius, float height, boolean fromTop, BlockPos pos) {
        long i = (long)(pos.func_177958_n() * 3129871) ^ (long)pos.func_177952_p() * 116129781L;
        i = i * i * 42317861L + i * 11L;
        float dx = ((float)(i >> 16 & 0xFL) / 15.0f - 0.5f) * 0.5f;
        float dz = ((float)(i >> 24 & 0xFL) / 15.0f - 0.5f) * 0.5f;
        this.func_149676_a(0.5f - radius + dx, fromTop ? 1.0f - height : 0.0f, 0.5f - radius + dz, 0.5f + radius + dx, fromTop ? 1.0f : height, 0.5f + radius + dz);
    }

    public boolean func_176193_a(World world, BlockPos pos, EnumFacing side, ItemStack stack) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos) && this.canBlockStay(world, pos, this.func_176203_a(stack.func_77960_j()));
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(worldIn, pos, state, neighborBlock);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(worldIn, pos, state)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        return false;
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.3f, 0.6f, pos);
    }
}

