/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.block.BlockBOPDoubleDecoration;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.util.block.BlockStateUtils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPDoublePlant
extends BlockBOPDoubleDecoration
implements IShearable {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", DoublePlantType.class);

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{HALF, VARIANT});
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((DoublePlantType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l();
    }

    public BlockBOPDoublePlant() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockBOPDoubleDecoration.Half.LOWER)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)DoublePlantType.FLAX)));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockBOPDoubleDecoration.Half.values()[meta >> 3])).func_177226_a((IProperty)VARIANT, (Comparable)((Object)DoublePlantType.values()[meta & 7]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((BlockBOPDoubleDecoration.Half)((Object)state.func_177229_b((IProperty)HALF))).ordinal() * 8 + ((DoublePlantType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public static ColoringType getColoringType(DoublePlantType plant) {
        switch (plant) {
            case FLAX: {
                return ColoringType.LIKE_GRASS;
            }
        }
        return ColoringType.PLAIN;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        switch (BlockBOPDoublePlant.getColoringType((DoublePlantType)((Object)state.func_177229_b((IProperty)VARIANT)))) {
            case LIKE_LEAVES: {
                return ColorizerFoliage.func_77468_c();
            }
            case LIKE_GRASS: {
                return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        switch (BlockBOPDoublePlant.getColoringType((DoublePlantType)((Object)worldIn.func_180495_p(pos).func_177229_b((IProperty)VARIANT)))) {
            case LIKE_LEAVES: {
                return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
            }
            case LIKE_GRASS: {
                return BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos);
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public int getItemRenderColor(IBlockState state, int tintIndex) {
        switch ((DoublePlantType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case FLAX: {
                return 0xFFFFFF;
            }
        }
        return this.func_180644_h(state);
    }

    @Override
    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        boolean isLower = (BlockBOPDoubleDecoration.Half)((Object)worldIn.func_180495_p(pos).func_177229_b((IProperty)HALF)) == BlockBOPDoubleDecoration.Half.LOWER;
        switch ((DoublePlantType)((Object)worldIn.func_180495_p(pos).func_177229_b((IProperty)VARIANT))) {
            default: 
        }
        this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.4f, isLower ? 1.0f : 0.8f, pos);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos lowerPos, IBlockState state) {
        DoublePlantType plant = (DoublePlantType)((Object)state.func_177229_b((IProperty)VARIANT));
        switch (plant) {
            case TALL_CATTAIL: {
                return BlockQueries.litFertileWaterside.matches(world, lowerPos.func_177977_b());
            }
            case EYEBULB: {
                return BlockQueries.hellish.matches(world, lowerPos.func_177977_b());
            }
        }
        return BlockQueries.litFertile.matches(world, lowerPos.func_177977_b());
    }

    @Override
    public List<ItemStack> getUpperDrops(IBlockAccess world, BlockPos upperPos, IBlockState upperState, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        DoublePlantType type = (DoublePlantType)((Object)upperState.func_177229_b((IProperty)VARIANT));
        switch (type) {
            case TALL_CATTAIL: {
                ret.add(BlockBOPPlant.paging.getVariantItem(BOPPlants.CATTAIL));
            }
        }
        return ret;
    }

    @Override
    public List<ItemStack> getLowerDrops(IBlockAccess world, BlockPos lowerPos, IBlockState lowerState, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        DoublePlantType type = (DoublePlantType)((Object)lowerState.func_177229_b((IProperty)VARIANT));
        switch (type) {
            case FLAX: {
                break;
            }
            case TALL_CATTAIL: {
                ret.add(BlockBOPPlant.paging.getVariantItem(BOPPlants.CATTAIL));
                break;
            }
            default: {
                ret.add(this.getVariantItem(type));
            }
        }
        return ret;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public List<ItemStack> getLowerShearDrops(ItemStack item, IBlockAccess world, BlockPos lowerPos, IBlockState lowerState, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        DoublePlantType type = (DoublePlantType)((Object)lowerState.func_177229_b((IProperty)VARIANT));
        switch (type) {
            case FLAX: {
                ret.add(this.getVariantItem(type));
            }
        }
        return ret;
    }

    public ItemStack getVariantItem(DoublePlantType type) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockBOPDoubleDecoration.Half.LOWER)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)type));
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        switch ((DoublePlantType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case TALL_CATTAIL: {
                return new ItemStack(BOPBlocks.plant_1, 1, BlockBOPPlant.paging.getIndex(BOPPlants.CATTAIL));
            }
        }
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        ImmutableSet<IBlockState> presets = BlockStateUtils.getBlockPresets(this);
        for (IBlockState state : presets) {
            if (state == BOPBlocks.double_plant.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)DoublePlantType.TALL_CATTAIL))) continue;
            list.add(new ItemStack(itemIn, 1, this.func_176201_c(state)));
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return Blocks.field_150329_H.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return Blocks.field_150329_H.getFlammability(world, pos, face);
    }

    public static enum ColoringType {
        PLAIN,
        LIKE_LEAVES,
        LIKE_GRASS;

    }

    public static enum DoublePlantType implements IStringSerializable
    {
        FLAX,
        TALL_CATTAIL,
        EYEBULB;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

