/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBOPBlock;
import biomesoplenty.api.block.ISustainsPlantType;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.item.ItemBOPBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPGrass
extends BlockGrass
implements IBOPBlock,
ISustainsPlantType {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", BOPGrassType.class);

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{field_176498_a, VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public int getItemRenderColor(IBlockState state, int tintIndex) {
        return this.func_180644_h(state);
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        BOPGrassType grassType = (BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT));
        switch (grassType) {
            case SPECTRAL_MOSS: 
            case OVERGROWN_NETHERRACK: {
                return grassType.func_176610_l();
            }
        }
        return grassType.func_176610_l() + "_grass_block";
    }

    public BlockBOPGrass() {
        this.func_149711_c(0.6f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(Block.field_149779_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176498_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.LOAMY)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    @Override
    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        IBlockState state = world.func_180495_p(pos);
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SMOLDERING: {
                return false;
            }
            case ORIGIN: {
                return true;
            }
            case OVERGROWN_NETHERRACK: {
                if (plantType != EnumPlantType.Nether) break;
                return true;
            }
        }
        switch (plantType) {
            case Desert: 
            case Plains: 
            case Cave: {
                return true;
            }
            case Beach: {
                return !world.func_175623_d(pos.func_177974_f()) && world.func_180495_p(pos.func_177974_f()).func_177230_c().func_149688_o() == Material.field_151586_h || !world.func_175623_d(pos.func_177976_e()) && world.func_180495_p(pos.func_177976_e()).func_177230_c().func_149688_o() == Material.field_151586_h || !world.func_175623_d(pos.func_177978_c()) && world.func_180495_p(pos.func_177978_c()).func_177230_c().func_149688_o() == Material.field_151586_h || !world.func_175623_d(pos.func_177968_d()) && world.func_180495_p(pos.func_177968_d()).func_177230_c().func_149688_o() == Material.field_151586_h;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos));
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SMOLDERING: {
                return true;
            }
        }
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176203_a(meta);
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: {
                if (!(world.field_73011_w instanceof WorldProviderHell)) break;
                world.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "mob.ghast.death", 20.0f, (float)Math.random() * 0.1f, true);
                for (int l = 0; l < 8; ++l) {
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 0.5 + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 0.5 + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SMOLDERING: {
                if (rand.nextInt(4) == 0) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
                if (rand.nextInt(6) != 0) break;
                worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
        }
        super.func_180655_c(worldIn, pos, state, rand);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: {
                if (!(world.field_73011_w instanceof WorldProviderHell)) break;
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.SMOLDERING)));
                break;
            }
            case SMOLDERING: {
                IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
                if (stateAbove.func_177230_c().func_149688_o() != Material.field_151597_y) break;
                world.func_175698_g(pos.func_177984_a());
                break;
            }
        }
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SMOLDERING: {
                break;
            }
            default: {
                this.spreadGrass(world, pos, state, rand, 4, 1, 3, 1);
            }
        }
    }

    public void spreadGrass(World world, BlockPos pos, IBlockState state, Random rand, int tries, int xzSpread, int downSpread, int upSpread) {
        if (world.func_175671_l(pos.func_177984_a()) < 4 && world.func_180495_p(pos.func_177984_a()).func_177230_c().getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
            world.func_175656_a(pos, BlockBOPGrass.getDirtBlockState(state));
        } else if (world.func_175671_l(pos.func_177984_a()) >= 9) {
            for (int i = 0; i < tries; ++i) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(xzSpread * 2 + 1) - xzSpread, rand.nextInt(downSpread + upSpread + 1) - downSpread, rand.nextInt(xzSpread * 2 + 1) - xzSpread);
                IBlockState target = world.func_180495_p(pos1);
                Block blockAboveTarget = world.func_180495_p(pos1.func_177984_a()).func_177230_c();
                IBlockState targetGrass = BlockBOPGrass.spreadsToGrass(state, target);
                if (targetGrass == null) break;
                if (world.func_175671_l(pos1.func_177984_a()) < 4 || blockAboveTarget.getLightOpacity((IBlockAccess)world, pos1.func_177984_a()) > 2) continue;
                world.func_175656_a(pos1, targetGrass);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: 
            case OVERGROWN_NETHERRACK: 
            case SMOLDERING: {
                return false;
            }
        }
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: 
            case OVERGROWN_NETHERRACK: 
            case SMOLDERING: {
                return false;
            }
        }
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockPos startPos = pos.func_177984_a();
        for (int i = 0; i < 128; ++i) {
            int walkLength = i / 16;
            BlockPos currPos = startPos;
            boolean walkOk = true;
            for (int j = 0; j < walkLength; ++j) {
                Block currBlockBelow = worldIn.func_180495_p((currPos = currPos.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c();
                if ((currBlockBelow == Blocks.field_150349_c || currBlockBelow == BOPBlocks.grass) && !worldIn.func_180495_p(currPos).func_177230_c().func_149721_r()) continue;
                walkOk = false;
                break;
            }
            if (!walkOk || !worldIn.func_175623_d(currPos)) continue;
            if (rand.nextInt(8) == 0) {
                worldIn.func_180494_b(currPos).plantFlower(worldIn, rand, currPos);
                continue;
            }
            IBlockState tallgrassState = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
            if (!Blocks.field_150329_H.func_180671_f(worldIn, currPos, tallgrassState)) continue;
            worldIn.func_175656_a(currPos, tallgrassState);
        }
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        float heightOffset = 0.0f;
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SMOLDERING: {
                heightOffset = 0.02f;
                break;
            }
        }
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)((float)(pos.func_177956_o() + 1) - heightOffset), (double)(pos.func_177952_p() + 1));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SMOLDERING: {
                entity.func_70015_d(2);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
                case LOAMY: 
                case SANDY: 
                case SILTY: {
                    effectRenderer.func_180533_a(pos, BlockBOPGrass.getDirtBlockState(state));
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockBOPGrass.getDirtBlock(state));
    }

    public int func_180651_a(IBlockState state) {
        return BlockBOPGrass.getDirtBlockMeta(state);
    }

    public static IBlockState getDirtBlockState(IBlockState state) {
        switch ((BOPGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: {
                return Blocks.field_150377_bs.func_176223_P();
            }
            case LOAMY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.LOAMY));
            }
            case SANDY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SANDY));
            }
            case SILTY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SILTY));
            }
            case OVERGROWN_NETHERRACK: {
                return Blocks.field_150424_aL.func_176223_P();
            }
        }
        return Blocks.field_150346_d.func_176203_a(BlockDirt.DirtType.DIRT.func_176925_a());
    }

    public static Block getDirtBlock(IBlockState state) {
        return BlockBOPGrass.getDirtBlockState(state).func_177230_c();
    }

    public static int getDirtBlockMeta(IBlockState state) {
        return BlockBOPGrass.getDirtBlock(state).func_176201_c(BlockBOPGrass.getDirtBlockState(state));
    }

    public static IBlockState spreadsToGrass(IBlockState source, IBlockState target) {
        switch ((BOPGrassType)((Object)source.func_177229_b((IProperty)VARIANT))) {
            case SPECTRAL_MOSS: {
                if (target.func_177230_c() != Blocks.field_150377_bs) break;
                return BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.SPECTRAL_MOSS));
            }
            case OVERGROWN_NETHERRACK: {
                if (target.func_177230_c() != Blocks.field_150424_aL) break;
                return BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.OVERGROWN_NETHERRACK));
            }
            case LOAMY: 
            case SANDY: 
            case SILTY: {
                if (target.func_177230_c() == Blocks.field_150346_d && target.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT) {
                    return Blocks.field_150349_c.func_176223_P();
                }
                if (target.func_177230_c() != BOPBlocks.dirt) break;
                return BlockBOPDirt.getGrassBlockState(target);
            }
            case ORIGIN: 
            case DAISY: {
                if ((target.func_177230_c() != Blocks.field_150346_d || target.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT) && (target.func_177230_c() != BOPBlocks.dirt || !Boolean.FALSE.equals(target.func_177229_b((IProperty)BlockBOPDirt.COARSE)))) break;
                return BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPGrassType.ORIGIN));
            }
        }
        return null;
    }

    public static enum BOPGrassType implements IStringSerializable
    {
        SPECTRAL_MOSS,
        SMOLDERING,
        LOAMY,
        SANDY,
        SILTY,
        ORIGIN,
        OVERGROWN_NETHERRACK,
        DAISY;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

