/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.IBOPBlock;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.entities.EntityWasp;
import biomesoplenty.common.item.ItemBOPBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;

public class BlockBOPHive
extends Block
implements IBOPBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", HiveType.class);

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public int getItemRenderColor(IBlockState state, int tintIndex) {
        return this.func_180644_h(state);
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((HiveType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l() + "_block";
    }

    public BlockBOPHive() {
        super(Material.field_151575_d);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149779_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)HiveType.HIVE)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)HiveType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((HiveType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch ((HiveType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case HONEYCOMB: {
                return BOPItems.honeycomb;
            }
            case FILLED_HONEYCOMB: {
                return BOPItems.filled_honeycomb;
            }
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        switch ((HiveType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case HONEYCOMB: {
                return 1 + random.nextInt(3);
            }
            case FILLED_HONEYCOMB: {
                return random.nextInt(2);
            }
            case EMPTY_HONEYCOMB: {
                return 0;
            }
        }
        return 1;
    }

    public int func_180651_a(IBlockState state) {
        switch ((HiveType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case HONEYCOMB: 
            case FILLED_HONEYCOMB: {
                return 0;
            }
        }
        return this.func_176201_c(state);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        switch ((HiveType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case EMPTY_HONEYCOMB: {
                EntityWasp wasp = new EntityWasp(worldIn);
                wasp.func_70012_b((double)pos.func_177958_n() + 0.6, pos.func_177956_o(), (double)pos.func_177952_p() + 0.3, 0.0f, 0.0f);
                worldIn.func_72838_d((Entity)wasp);
                break;
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public static enum HiveType implements IStringSerializable
    {
        HIVE,
        HONEYCOMB,
        EMPTY_HONEYCOMB,
        FILLED_HONEYCOMB;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

