/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.item.ItemBOPBlock;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBOPMushroom
extends BlockBOPDecoration {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", MushroomType.class);

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public int getItemRenderColor(IBlockState state, int tintIndex) {
        return this.func_180644_h(state);
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((MushroomType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l();
    }

    public BlockBOPMushroom() {
        this.setBlockBoundsByRadiusAndHeight(0.2f, 0.4f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)MushroomType.TOADSTOOL)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)MushroomType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((MushroomType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        switch ((MushroomType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)VARIANT))) {
            case GLOWSHROOM: {
                return 6;
            }
        }
        return super.func_149750_m();
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        switch ((MushroomType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case TOADSTOOL: {
                return BlockQueries.fertileOrNetherrack.matches(world, pos.func_177977_b());
            }
            case GLOWSHROOM: {
                return BlockQueries.sustainsCave.matches(world, pos.func_177977_b());
            }
            case SHADOW_SHROOM: {
                return BlockQueries.endish.matches(world, pos.func_177977_b());
            }
        }
        return BlockQueries.fertile.matches(world, pos.func_177977_b());
    }

    public static enum MushroomType implements IStringSerializable
    {
        TOADSTOOL,
        PORTOBELLO,
        BLUE_MILK_CAP,
        GLOWSHROOM,
        FLAT_MUSHROOM,
        SHADOW_SHROOM;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

