/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.enums.BOPPlants;
import biomesoplenty.common.item.ItemBOPPlant;
import biomesoplenty.common.util.block.VariantPagingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPPlant
extends BlockBOPDecoration
implements IShearable {
    public static VariantPagingHelper<BlockBOPPlant, BOPPlants> paging = new VariantPagingHelper(16, BOPPlants.class);
    private static IProperty currentVariantProperty;
    public IProperty variantProperty;

    public static void createAllPages() {
        int numPages = paging.getNumPages();
        for (int i = 0; i < numPages; ++i) {
            currentVariantProperty = paging.getVariantProperty(i);
            paging.addBlock(i, new BlockBOPPlant());
        }
    }

    protected BlockState func_180661_e() {
        this.variantProperty = currentVariantProperty;
        return new BlockState((Block)this, new IProperty[]{this.variantProperty});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPPlant.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{this.variantProperty};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        switch (plant) {
            default: 
        }
        return plant.func_176610_l();
    }

    private BlockBOPPlant() {
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)paging.getVariant(this, meta)));
    }

    public int func_176201_c(IBlockState state) {
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        return paging.getIndex(plant);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        switch (plant) {
            case SHORTGRASS: 
            case MEDIUMGRASS: 
            case WHEATGRASS: 
            case DAMPGRASS: {
                if (rand.nextInt(8) != 0) break;
                ret.add(ForgeHooks.getGrassSeed((Random)rand));
                break;
            }
            case SPROUT: {
                if (rand.nextInt(50) != 0) break;
                ret.add(new ItemStack(rand.nextInt(2) == 0 ? Items.field_151172_bF : Items.field_151174_bG));
                break;
            }
            case KORU: {
                if (rand.nextInt(64) != 0) break;
                ret.add(new ItemStack(BOPItems.turnip_seeds));
                break;
            }
            case BERRYBUSH: {
                ret.add(new ItemStack(BOPItems.berries));
                break;
            }
            case WILDRICE: {
                if (rand.nextInt(5) != 0) break;
                ret.add(paging.getVariantItem(plant));
                break;
            }
            case CATTAIL: 
            case RIVERCANE: 
            case TINYCACTUS: 
            case WITHERWART: 
            case REED: 
            case ROOT: 
            case RAFFLESIA: {
                ret.add(paging.getVariantItem(plant));
                break;
            }
        }
        return ret;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tileentity) {
        super.func_180657_a(world, player, pos, state, tileentity);
        boolean usingShears = player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemShears;
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case THORN: {
                if (usingShears) break;
                player.func_70097_a(DamageSource.field_76367_g, 2.0f);
                break;
            }
        }
    }

    public boolean func_176200_f(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        switch (plant) {
            case WILDRICE: 
            case CATTAIL: 
            case RIVERCANE: 
            case TINYCACTUS: 
            case WITHERWART: 
            case RAFFLESIA: 
            case THORN: {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != this) {
            return false;
        }
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case WITHERWART: {
                int n = 3;
                for (int i = 0; i < n; i = (int)((byte)(i + 1))) {
                    for (int j = 0; j < n; j = (int)((byte)(j + 1))) {
                        for (int k = 0; k < n; k = (int)((byte)(k + 1))) {
                            double x = (double)pos.func_177958_n() + ((double)i + 0.5) / (double)n;
                            double y = (double)pos.func_177956_o() + ((double)j + 0.5) / (double)n;
                            double z = (double)pos.func_177952_p() + ((double)k + 0.5) / (double)n;
                            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
                break;
            }
        }
        return false;
    }

    public static ColoringType getColoringType(BOPPlants plant) {
        switch (plant) {
            case BERRYBUSH: 
            case SHRUB: 
            case LEAFPILE: 
            case POISONIVY: 
            case BUSH: {
                return ColoringType.LIKE_LEAVES;
            }
            case SHORTGRASS: 
            case MEDIUMGRASS: 
            case WHEATGRASS: 
            case DAMPGRASS: 
            case SPROUT: 
            case KORU: 
            case CLOVERPATCH: {
                return ColoringType.LIKE_GRASS;
            }
        }
        return ColoringType.PLAIN;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        switch (BlockBOPPlant.getColoringType((BOPPlants)((Object)state.func_177229_b(this.variantProperty)))) {
            case LIKE_LEAVES: {
                return ColorizerFoliage.func_77468_c();
            }
            case LIKE_GRASS: {
                return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        switch (BlockBOPPlant.getColoringType((BOPPlants)((Object)worldIn.func_180495_p(pos).func_177229_b(this.variantProperty)))) {
            case LIKE_LEAVES: {
                return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
            }
            case LIKE_GRASS: {
                return BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos);
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public int getItemRenderColor(IBlockState state, int tintIndex) {
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case BERRYBUSH: 
            case SHRUB: {
                return 0xFFFFFF;
            }
        }
        return this.func_180644_h(state);
    }

    @Override
    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case LEAFPILE: 
            case CLOVERPATCH: 
            case DEADLEAFPILE: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.5f, 0.015625f, pos);
                break;
            }
            case SHORTGRASS: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.4f, 0.25f, pos);
                break;
            }
            case MEDIUMGRASS: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.4f, 0.6f, pos);
                break;
            }
            case CATTAIL: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.375f, 1.0f, pos);
                break;
            }
            case TINYCACTUS: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.3f, 0.7f, pos);
                break;
            }
            case ROOT: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.4f, 0.8f, true, pos);
                break;
            }
            case REED: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.3f, 0.8f, pos);
                this.field_149760_C = -1.0;
                break;
            }
            default: {
                this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.4f, 0.8f, pos);
            }
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        BOPPlants plant = (BOPPlants)((Object)state.func_177229_b(this.variantProperty));
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        switch (plant) {
            case TINYCACTUS: 
            case DEADGRASS: 
            case DESERTGRASS: {
                return BlockQueries.litDry.matches(world, pos.func_177977_b());
            }
            case DESERTSPROUTS: 
            case DUNEGRASS: {
                return BlockQueries.litSand.matches(world, pos.func_177977_b());
            }
            case SPECTRALFERN: {
                return BlockQueries.spectralMoss.matches(world, pos.func_177977_b());
            }
            case THORN: {
                return BlockQueries.litFertileOrDry.matches(world, pos.func_177977_b());
            }
            case CATTAIL: {
                return BlockQueries.litFertileWaterside.matches(world, pos.func_177977_b());
            }
            case RIVERCANE: {
                return BlockQueries.litFertileWaterside.matches(world, pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()) == state;
            }
            case WITHERWART: {
                return BlockQueries.sustainsNether.matches(world, pos.func_177977_b());
            }
            case REED: {
                return BlockQueries.suitableForReed.matches(world, pos.func_177977_b());
            }
            case ROOT: {
                return BlockQueries.fertile.matches(world, pos.func_177984_a());
            }
        }
        return BlockQueries.litFertile.matches(world, pos.func_177977_b());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case POISONIVY: {
                if (rand.nextInt(32) != 0) break;
                worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
        }
        super.func_180655_c(worldIn, pos, state, rand);
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case BUSH: {
                if (rand.nextInt(80) != 0 || worldIn.func_175671_l(pos.func_177984_a()) < 9) break;
                worldIn.func_175656_a(pos, paging.getVariantState(BOPPlants.BERRYBUSH));
                break;
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case POISONIVY: {
                if (!(entity instanceof EntityPlayer)) break;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100));
                break;
            }
            case TINYCACTUS: 
            case THORN: {
                boolean wearingLeatherLeggings;
                if (!(entity instanceof EntityPlayer)) break;
                InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
                boolean wearingLeatherBoots = inventory.field_70460_b[0] != null && inventory.field_70460_b[0].func_77973_b() == Items.field_151021_T;
                boolean bl = wearingLeatherLeggings = inventory.field_70460_b[1] != null && inventory.field_70460_b[1].func_77973_b() == Items.field_151026_S;
                if (wearingLeatherBoots || wearingLeatherLeggings) break;
                entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
                break;
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case BERRYBUSH: {
                worldIn.func_175656_a(pos, paging.getVariantState(BOPPlants.BUSH));
                EntityItem berries = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(BOPItems.berries));
                if (worldIn.field_72995_K) break;
                worldIn.func_72838_d((Entity)berries);
                if (!(playerIn instanceof FakePlayer)) {
                    berries.func_70100_b_(playerIn);
                }
                return true;
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        switch ((BOPPlants)((Object)state.func_177229_b(this.variantProperty))) {
            case CATTAIL: 
            case RIVERCANE: {
                return false;
            }
        }
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        BOPPlants plant = (BOPPlants)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (plant) {
            case CATTAIL: 
            case RIVERCANE: 
            case TINYCACTUS: 
            case WITHERWART: 
            case REED: 
            case ROOT: {
                break;
            }
            case BERRYBUSH: {
                ret.add(paging.getVariantItem(BOPPlants.BUSH));
                break;
            }
            default: {
                ret.add(paging.getVariantItem(plant));
            }
        }
        return ret;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPPlants plant = (BOPPlants)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (plant) {
            case WILDRICE: {
                return 0;
            }
            case CATTAIL: {
                return 0;
            }
            case RIVERCANE: {
                return 0;
            }
            case WITHERWART: {
                return 0;
            }
            case REED: {
                return 0;
            }
            case ROOT: {
                return 0;
            }
            case RAFFLESIA: {
                return 0;
            }
        }
        return Blocks.field_150329_H.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPPlants plant = (BOPPlants)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (plant) {
            case WILDRICE: {
                return 0;
            }
            case CATTAIL: {
                return 0;
            }
            case RIVERCANE: {
                return 0;
            }
            case WITHERWART: {
                return 0;
            }
            case REED: {
                return 0;
            }
            case ROOT: {
                return 0;
            }
            case RAFFLESIA: {
                return 0;
            }
        }
        return Blocks.field_150329_H.getFireSpreadSpeed(world, pos, face);
    }

    public static enum ColoringType {
        PLAIN,
        LIKE_LEAVES,
        LIKE_GRASS;

    }
}

