/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBOPBlock;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.item.ItemBOPBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBOPSeaweed
extends BlockBOPDecoration
implements IBOPBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", SeaweedType.class);
    public static final PropertyEnum POSITION = PropertyEnum.func_177709_a((String)"position", SeaweedPosition.class);

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BlockLiquid.field_176367_b, POSITION, VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public int getItemRenderColor(IBlockState state, int tintIndex) {
        return this.func_180644_h(state);
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{BlockLiquid.field_176367_b};
    }

    @Override
    public String getStateName(IBlockState state) {
        SeaweedType type = (SeaweedType)((Object)state.func_177229_b((IProperty)VARIANT));
        return type.func_176610_l();
    }

    public BlockBOPSeaweed() {
        super(Material.field_151586_h);
        this.func_149672_a(Block.field_149776_m);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15)).func_177226_a((IProperty)POSITION, (Comparable)((Object)SeaweedPosition.SINGLE)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)SeaweedType.KELP)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean seaweedBelow;
        boolean seaweedAbove = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean bl = seaweedBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        SeaweedPosition position = seaweedAbove && seaweedBelow ? SeaweedPosition.MIDDLE : (seaweedAbove ? SeaweedPosition.BOTTOM : (seaweedBelow ? SeaweedPosition.TOP : SeaweedPosition.SINGLE));
        return state.func_177226_a((IProperty)POSITION, (Comparable)((Object)position));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)SeaweedType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((SeaweedType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    @Override
    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        this.setBlockBoundsByRadiusAndHeightWithXZOffset(0.4f, 0.8f, pos);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return !(!BlockQueries.fertileSeaBed.matches(world, pos.func_177977_b()) && world.func_180495_p(pos.func_177977_b()) != state || !BlockQueries.underwater.matches(world, pos.func_177984_a()) && world.func_180495_p(pos.func_177984_a()) != state);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
    }

    public static enum SeaweedPosition implements IStringSerializable
    {
        SINGLE,
        BOTTOM,
        MIDDLE,
        TOP;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }

    public static enum SeaweedType implements IStringSerializable
    {
        KELP;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

