/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.handler.decoration;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.biome.generation.GenerationManager;
import biomesoplenty.api.biome.generation.GeneratorStage;
import biomesoplenty.api.biome.generation.IGenerator;
import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DecorateBiomeEventHandler {
    @SubscribeEvent
    public void onPreBiomeDecorate(DecorateBiomeEvent.Pre event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.world.func_175624_G())) {
            return;
        }
        DecorateBiomeEventHandler.runGeneratorStage(event.world, event.rand, event.pos, GeneratorStage.PRE);
    }

    @SubscribeEvent
    public void onBiomeDecorate(DecorateBiomeEvent.Decorate event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.world.func_175624_G())) {
            return;
        }
        if (event.type != DecorateBiomeEvent.Decorate.EventType.CUSTOM) {
            boolean allow = DecorateBiomeEventHandler.runGeneratorStage(event.world, event.rand, event.pos, GeneratorStage.mapDecorateType(event.type));
            event.setResult(allow ? Event.Result.ALLOW : Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPostBiomeDecorate(DecorateBiomeEvent.Post event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.world.func_175624_G())) {
            return;
        }
        DecorateBiomeEventHandler.runGeneratorStage(event.world, event.rand, event.pos, GeneratorStage.POST);
    }

    @SubscribeEvent
    public void onPreGenerateOres(OreGenEvent.Pre event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.world.func_175624_G())) {
            return;
        }
        DecorateBiomeEventHandler.runGeneratorStage(event.world, event.rand, event.pos, GeneratorStage.ORE_PRE);
    }

    @SubscribeEvent
    public void onPostGenerateOres(OreGenEvent.Post event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.world.func_175624_G())) {
            return;
        }
        DecorateBiomeEventHandler.runGeneratorStage(event.world, event.rand, event.pos, GeneratorStage.ORE_POST);
    }

    private static boolean runGeneratorStage(World world, Random random, BlockPos pos, GeneratorStage stage) {
        BiomeGenBase biome = world.func_180494_b(pos.func_177982_a(16, 0, 16));
        IExtendedBiome extendedBiome = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome);
        if (extendedBiome != null) {
            GenerationManager generationManager = extendedBiome.getGenerationManager();
            for (IGenerator generator : generationManager.getGeneratorsForStage(stage)) {
                generator.scatter(world, random, pos);
            }
        }
        return true;
    }
}

