/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.init;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.util.block.BlockQuery;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class ModBlockQueries {
    public static void init() {
        BlockQueries.anything = BlockQuery.anything;
        BlockQueries.nothing = BlockQuery.nothing;
        BlockQueries.hasWater = new BlockQuery.IBlockPosQuery(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                return world.func_180495_p(pos.func_177976_e()).func_177230_c().func_149688_o() == Material.field_151586_h || world.func_180495_p(pos.func_177974_f()).func_177230_c().func_149688_o() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_177230_c().func_149688_o() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_177230_c().func_149688_o() == Material.field_151586_h;
            }
        };
        BlockQueries.airAbove = new BlockQuery.IBlockPosQuery(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                return world.func_175623_d(pos.func_177984_a());
            }
        };
        BlockQueries.airBelow = new BlockQuery.IBlockPosQuery(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                return world.func_175623_d(pos.func_177977_b());
            }
        };
        BlockQueries.waterCovered = new BlockQuery.IBlockPosQuery(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                return world.func_180495_p(pos).func_177230_c().func_149688_o() == Material.field_151586_h && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151586_h;
            }
        };
        BlockQueries.breakable = new BlockQuery.IBlockPosQuery(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                return world.func_180495_p(pos).func_177230_c().func_176195_g(world, pos) >= 0.0f;
            }
        };
        BlockQueries.solid = new BlockQuery.IBlockPosQuery(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                return world.isSideSolid(pos, EnumFacing.UP);
            }
        };
        BlockQueries.replaceable = new BlockQuery.IBlockPosQuery(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                return world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos);
            }
        };
        BlockQueries.air = new BlockQuery.BlockQueryMaterial(Material.field_151579_a);
        BlockQueries.airOrLeaves = new BlockQuery.BlockQueryMaterial(Material.field_151579_a, Material.field_151584_j);
        BlockQueries.surfaceBlocks = new BlockQuery.BlockQueryMaterial(Material.field_175972_I, Material.field_151571_B, Material.field_151577_b, Material.field_151578_c, Material.field_151588_w, Material.field_151587_i, Material.field_151598_x, Material.field_151576_e, Material.field_151595_p, Material.field_151586_h);
        BlockQueries.groundBlocks = new BlockQuery.BlockQueryMaterial(Material.field_175972_I, Material.field_151571_B, Material.field_151577_b, Material.field_151578_c, Material.field_151598_x, Material.field_151576_e, Material.field_151595_p);
        BlockQueries.fertile = BlockQuery.buildAnd().sustainsPlant(EnumPlantType.Plains).create();
        BlockQueries.fertileOrNetherrack = BlockQuery.buildOr().sustainsPlant(EnumPlantType.Plains).blocks(Blocks.field_150424_aL).states(BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.OVERGROWN_NETHERRACK))).create();
        BlockQueries.sustainsCave = BlockQuery.buildAnd().sustainsPlant(EnumPlantType.Cave).create();
        BlockQueries.sustainsNether = BlockQuery.buildAnd().sustainsPlant(EnumPlantType.Nether).create();
        BlockQueries.endish = BlockQuery.buildOr().blocks(Blocks.field_150377_bs).states(BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SPECTRAL_MOSS))).create();
        BlockQueries.hellish = BlockQuery.buildOr().blocks(Blocks.field_150424_aL, BOPBlocks.flesh).states(BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.OVERGROWN_NETHERRACK))).create();
        BlockQueries.litBeach = BlockQuery.buildAnd().sustainsPlant(EnumPlantType.Beach).withLightAboveAtLeast(8).create();
        BlockQueries.litFertileWaterside = BlockQuery.buildAnd().sustainsPlant(EnumPlantType.Plains).byWater().create();
        BlockQueries.litFertile = BlockQuery.buildAnd().sustainsPlant(EnumPlantType.Plains).withLightAboveAtLeast(8).create();
        BlockQueries.litSand = BlockQuery.buildAnd().materials(Material.field_151595_p).withLightAboveAtLeast(8).create();
        BlockQueries.litDry = BlockQuery.buildAnd().sustainsPlant(EnumPlantType.Desert).withLightAboveAtLeast(8).create();
        BlockQueries.litFertileOrDry = BlockQuery.buildOr().add(BlockQueries.litFertile).add(BlockQueries.litDry).create();
        BlockQueries.spectralMoss = new BlockQuery.BlockQueryState(BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SPECTRAL_MOSS)));
        BlockQueries.underwater = new BlockQuery.BlockQueryMaterial(Material.field_151586_h);
        BlockQueries.fertileSeaBed = new BlockQuery.BlockQueryMaterial(Material.field_151578_c, Material.field_151595_p, Material.field_151571_B, Material.field_151583_m);
        BlockQueries.suitableForReed = BlockQuery.buildAnd().add(new BlockQuery.IBlockPosQuery(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                BlockPos groundPos = pos.func_177977_b();
                return world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(groundPos).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(groundPos).func_177230_c().isSideSolid((IBlockAccess)world, groundPos, EnumFacing.UP);
            }
        }).withLightAboveAtLeast(8).create();
        BlockQueries.rootsCanDigThrough = new BlockQuery.BlockQueryMaterial(Material.field_151579_a, Material.field_151586_h, Material.field_151578_c, Material.field_151577_b, Material.field_151595_p, Material.field_151571_B, Material.field_151585_k, Material.field_151584_j);
    }
}

