/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.init;

import biomesoplenty.common.init.ModBiomes;
import biomesoplenty.common.util.biome.BiomeUtils;
import biomesoplenty.core.BiomesOPlenty;
import java.util.Map;
import net.minecraft.world.biome.BiomeGenBase;

public class ModChecks {
    public static void postInit() {
        ModChecks.verifyBiomeIds();
    }

    private static void verifyBiomeIds() {
        BiomesOPlenty.logger.info("Checking for biome id conflicts...");
        Map<String, Integer> biomeIdMap = ModBiomes.biomeIdMap;
        for (Map.Entry<String, Integer> entry : biomeIdMap.entrySet()) {
            BiomeGenBase biome;
            String biomeIdentifier = entry.getKey();
            int id = entry.getValue();
            if (id < 0 || id > BiomeGenBase.func_150565_n().length || (biome = BiomeGenBase.func_150568_d((int)id)) != null && BiomeUtils.getBiomeIdentifier(biome).equals(biomeIdentifier)) continue;
            throw new RuntimeException("Unexpected biome " + biome.field_76791_y + " for id " + id + ". This is not a bug, please ensure your biome ids are configured to be unique.");
        }
        BiomesOPlenty.logger.info("No conflicts found");
    }
}

