/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.item;

import biomesoplenty.common.util.NBTUtil;
import biomesoplenty.core.BiomesOPlenty;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class ItemFlowerBasket
extends Item {
    public ItemFlowerBasket() {
        this.field_77777_bU = 1;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            NBTTagCompound compound = NBTUtil.getOrCreateStackNBT(stack);
            ItemFlowerBasket.clearOpenBaskets(player);
            compound.func_74757_a("BasketOpen", true);
            player.openGui((Object)BiomesOPlenty.instance, 0, world, 0, 0, 0);
        }
        return stack;
    }

    public static ItemStack findBasketStack(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemFlowerBasket)) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack findOpenBasketStack(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!ItemFlowerBasket.isBasketOpen(stack)) continue;
            return stack;
        }
        return null;
    }

    public static boolean isBasketOpen(ItemStack stack) {
        NBTTagCompound compound;
        if (stack != null && stack.func_77973_b() instanceof ItemFlowerBasket && stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("BasketOpen")) {
            return compound.func_74767_n("BasketOpen");
        }
        return false;
    }

    public static void clearOpenBaskets(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            ItemFlowerBasket.closeIfBasket(stack);
        }
    }

    public static void closeIfBasket(ItemStack stack) {
        if (ItemFlowerBasket.isBasketOpen(stack)) {
            NBTTagCompound compound = stack.func_77978_p();
            compound.func_74757_a("BasketOpen", false);
        }
    }

    public static boolean isStackSuitableForBasket(ItemStack stack) {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        return !(item instanceof ItemFlowerBasket) && block != null && (block instanceof IPlantable || block instanceof IGrowable || block instanceof IShearable);
    }
}

