/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.item;

import biomesoplenty.common.entities.EntityPixie;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJarFilled
extends Item {
    public ItemJarFilled() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
        for (JarContents contents : JarContents.values()) {
            subItems.add(new ItemStack(itemIn, 1, contents.ordinal()));
        }
    }

    public int func_77647_b(int metadata) {
        return metadata;
    }

    public JarContents getContentsType(ItemStack stack) {
        int meta = stack.func_77960_j();
        try {
            return JarContents.values()[meta];
        }
        catch (Exception e) {
            return JarContents.HONEY;
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "_" + this.getContentsType(stack).func_176610_l();
    }

    protected Vec3 getAirPositionInFrontOfPlayer(World world, EntityPlayer player, double targetDistance) {
        Vec3 targetPosition;
        float cosYaw = MathHelper.func_76134_b((float)(-player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)(-player.field_70125_A * ((float)Math.PI / 180)));
        float facingX = sinYaw * cosPitch;
        float facingY = MathHelper.func_76126_a((float)(-player.field_70125_A * ((float)Math.PI / 180)));
        float facingZ = cosYaw * cosPitch;
        Vec3 playerEyePosition = new Vec3(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        MovingObjectPosition hit = world.func_147447_a(playerEyePosition, targetPosition = playerEyePosition.func_72441_c((double)facingX * targetDistance, (double)facingY * targetDistance, (double)facingZ * targetDistance), true, false, false);
        if (hit == null) {
            return targetPosition;
        }
        double distance = playerEyePosition.func_72438_d(hit.field_72307_f) * 0.9;
        return playerEyePosition.func_72441_c((double)facingX * distance, (double)facingY * distance, (double)facingZ * distance);
    }

    public boolean releasePixie(ItemStack stack, World world, EntityPlayer player, Vec3 releasePoint) {
        if (world.field_73011_w.func_76569_d()) {
            EntityPixie pixie = new EntityPixie(world);
            pixie.func_70012_b(releasePoint.field_72450_a, releasePoint.field_72448_b, releasePoint.field_72449_c, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            world.func_72838_d((Entity)pixie);
            pixie.func_70642_aH();
            if (stack.func_82837_s()) {
                pixie.func_96094_a(stack.func_82833_r());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        player.func_146105_b((IChatComponent)new ChatComponentText("\u00a75Pixies cannot survive in this environment!"));
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        switch (this.getContentsType(stack)) {
            case PIXIE: {
                if (this.getContentsType(stack) == JarContents.PIXIE) {
                    Vec3 releasePoint = this.getAirPositionInFrontOfPlayer(world, player, 0.8);
                    this.releasePixie(stack, world, player, releasePoint);
                }
                return stack;
            }
        }
        return stack;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        switch (this.getContentsType(stack)) {
            case PIXIE: {
                double distX = (double)hitX - player.field_70165_t;
                double distY = (double)hitY - (player.field_70163_u + (double)player.func_70047_e());
                double distZ = (double)hitZ - player.field_70161_v;
                double a = 0.9;
                Vec3 releasePoint = new Vec3(player.field_70165_t + a * distX, player.field_70163_u + (double)player.func_70047_e() + a * distY, player.field_70161_v + a * distZ);
                return this.releasePixie(stack, world, player, releasePoint);
            }
        }
        return false;
    }

    public static enum JarContents implements IStringSerializable
    {
        HONEY,
        POISON,
        PIXIE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

