/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.biome;

import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.WorldTypeBOP;
import biomesoplenty.core.BiomesOPlenty;
import com.google.common.base.CaseFormat;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.ChunkProviderSettings;

public class BiomeUtils {
    public static int getBiomeSize(World world) {
        String generatorSettingsJson = world.func_72912_H().func_82571_y();
        if (world.func_175624_G() instanceof WorldTypeBOP) {
            return new BOPWorldSettings((String)generatorSettingsJson).biomeSize.getValue();
        }
        return ChunkProviderSettings.Factory.func_177865_a((String)generatorSettingsJson).func_177864_b().field_177780_G;
    }

    public static String getBiomeIdentifier(BiomeGenBase biome) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, biome.field_76791_y.replace(" ", ""));
    }

    public static BlockPos spiralOutwardsLookingForBiome(World world, BiomeGenBase biomeToFind, double startX, double startZ) {
        int sampleSpacing = 4 << BiomeUtils.getBiomeSize(world);
        int maxDist = sampleSpacing * 100;
        return BiomeUtils.spiralOutwardsLookingForBiome(world, biomeToFind, startX, startZ, maxDist, sampleSpacing);
    }

    public static BlockPos spiralOutwardsLookingForBiome(World world, BiomeGenBase biomeToFind, double startX, double startZ, int maxDist, int sampleSpace) {
        if (maxDist <= 0 || sampleSpace <= 0) {
            throw new IllegalArgumentException("maxDist and sampleSpace must be positive");
        }
        WorldChunkManager chunkManager = world.func_72959_q();
        double a = (double)sampleSpace / Math.sqrt(Math.PI);
        double b = 2.0 * Math.sqrt(Math.PI);
        double x = 0.0;
        double z = 0.0;
        double dist = 0.0;
        int n = 0;
        n = 0;
        while (dist < (double)maxDist) {
            double rootN = Math.sqrt(n);
            dist = a * rootN;
            x = startX + dist * Math.sin(b * rootN);
            BiomeGenBase[] biomesAtSample = chunkManager.func_76931_a(null, (int)x, (int)(z = startZ + dist * Math.cos(b * rootN)), 1, 1, false);
            if (biomesAtSample[0] == biomeToFind) {
                BiomesOPlenty.logger.info("Found " + biomeToFind.field_76791_y + " after " + n + " samples, spaced " + sampleSpace + " blocks apart at (" + (int)x + "," + (int)z + ") distance " + (int)dist);
                return new BlockPos((int)x, 0, (int)z);
            }
            ++n;
        }
        BiomesOPlenty.logger.info("Failed to find " + biomeToFind.field_76791_y + " gave up after " + n + " samples, spaced " + sampleSpace + " blocks apart distance " + (int)dist);
        return null;
    }
}

