/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.WorldTypeBOP;
import biomesoplenty.common.world.layer.BOPGenLayer;
import biomesoplenty.common.world.layer.GenLayerBiomeBOP;
import biomesoplenty.common.world.layer.GenLayerBiomeEdgeBOP;
import biomesoplenty.common.world.layer.GenLayerBiomeIslands;
import biomesoplenty.common.world.layer.GenLayerClimate;
import biomesoplenty.common.world.layer.GenLayerIslandBOP;
import biomesoplenty.common.world.layer.GenLayerLargeIsland;
import biomesoplenty.common.world.layer.GenLayerRaggedEdges;
import biomesoplenty.common.world.layer.GenLayerRainfallNoise;
import biomesoplenty.common.world.layer.GenLayerRainfallRandom;
import biomesoplenty.common.world.layer.GenLayerRiverMixBOP;
import biomesoplenty.common.world.layer.GenLayerShoreBOP;
import biomesoplenty.common.world.layer.GenLayerSubBiomesBOP;
import biomesoplenty.common.world.layer.GenLayerTemperatureLatitude;
import biomesoplenty.common.world.layer.GenLayerTemperatureNoise;
import biomesoplenty.common.world.layer.GenLayerTemperatureRandom;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;

public class WorldChunkManagerBOP
extends WorldChunkManager {
    public WorldChunkManagerBOP(long seed, WorldType worldType, String chunkProviderSettings) {
        if (!(worldType instanceof WorldTypeBOP)) {
            throw new RuntimeException("WorldChunkManagerBOP requires a world of type WorldTypeBOP");
        }
        System.out.println("settings for world: " + chunkProviderSettings);
        BOPWorldSettings settings = new BOPWorldSettings(chunkProviderSettings);
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            IExtendedBiome extBiome;
            if (biome == null || (extBiome = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome)) == null) continue;
            extBiome.applySettings(settings);
        }
        GenLayer[] agenlayer = WorldChunkManagerBOP.setupBOPGenLayers(seed, (WorldTypeBOP)worldType, settings);
        agenlayer = this.getModdedBiomeGenerators(worldType, seed, agenlayer);
        this.field_76944_d = agenlayer[0];
        this.field_76945_e = agenlayer[1];
    }

    public WorldChunkManagerBOP(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t(), world.func_72912_H().func_82571_y());
    }

    public static GenLayer initialLandAndSeaLayer(BOPWorldSettings.LandMassScheme scheme) {
        Object stack;
        System.out.println("Setting up landmass " + scheme.name());
        switch (scheme) {
            case CONTINENTS: {
                stack = new GenLayerIslandBOP(1L, 4);
                stack = new GenLayerFuzzyZoom(2000L, (GenLayer)stack);
                stack = new GenLayerZoom(2001L, (GenLayer)stack);
                stack = new GenLayerIslandBOP(3L, 12, (GenLayer)stack);
                stack = new GenLayerZoom(2002L, (GenLayer)stack);
                stack = new GenLayerRaggedEdges(4L, (GenLayer)stack);
                break;
            }
            case ARCHIPELAGO: {
                stack = new GenLayerIslandBOP(1L, 5);
                break;
            }
            default: {
                stack = new GenLayerIsland(1L);
                stack = new GenLayerFuzzyZoom(2000L, (GenLayer)stack);
                stack = new GenLayerRaggedEdges(1L, (GenLayer)stack);
                stack = new GenLayerZoom(2001L, (GenLayer)stack);
                stack = new GenLayerRaggedEdges(2L, (GenLayer)stack);
                stack = new GenLayerRaggedEdges(50L, (GenLayer)stack);
                stack = new GenLayerRaggedEdges(70L, (GenLayer)stack);
                stack = new GenLayerRemoveTooMuchOcean(2L, (GenLayer)stack);
                stack = new GenLayerRaggedEdges(3L, (GenLayer)stack);
                stack = new GenLayerZoom(2002L, (GenLayer)stack);
                stack = new GenLayerZoom(2003L, (GenLayer)stack);
                stack = new GenLayerRaggedEdges(4L, (GenLayer)stack);
            }
        }
        return stack;
    }

    public static GenLayer climateLayer(BOPWorldSettings settings, long worldSeed) {
        BOPGenLayer rainfall;
        BOPGenLayer temperature;
        switch (settings.tempScheme) {
            default: {
                temperature = new GenLayerTemperatureLatitude(2L, 16.0, worldSeed);
                break;
            }
            case SMALL_ZONES: {
                temperature = new GenLayerTemperatureNoise(3L, worldSeed, 0.14);
                break;
            }
            case MEDIUM_ZONES: {
                temperature = new GenLayerTemperatureNoise(4L, worldSeed, 0.08);
                break;
            }
            case LARGE_ZONES: {
                temperature = new GenLayerTemperatureNoise(5L, worldSeed, 0.04);
                break;
            }
            case RANDOM: {
                temperature = new GenLayerTemperatureRandom(6L);
            }
        }
        switch (settings.rainScheme) {
            case SMALL_ZONES: {
                rainfall = new GenLayerRainfallNoise(7L, worldSeed, 0.14);
                break;
            }
            default: {
                rainfall = new GenLayerRainfallNoise(8L, worldSeed, 0.08);
                break;
            }
            case LARGE_ZONES: {
                rainfall = new GenLayerRainfallNoise(9L, worldSeed, 0.04);
                break;
            }
            case RANDOM: {
                rainfall = new GenLayerRainfallRandom(10L);
            }
        }
        GenLayerClimate climate = new GenLayerClimate(103L, temperature, rainfall);
        return climate;
    }

    public static GenLayer allocateBiomes(long worldSeed, WorldTypeBOP worldType, BOPWorldSettings settings, GenLayer mainBranch, GenLayer subBiomesInit, GenLayer climateLayer) {
        BOPGenLayer biomesLayer = new GenLayerBiomeBOP(200L, mainBranch, climateLayer, settings);
        biomesLayer = new GenLayerZoom(1000L, (GenLayer)biomesLayer);
        subBiomesInit = new GenLayerZoom(1000L, subBiomesInit);
        climateLayer = new GenLayerZoom(1000L, climateLayer);
        switch (settings.landScheme) {
            case ARCHIPELAGO: {
                biomesLayer = new GenLayerBiomeIslands(15L, biomesLayer, climateLayer, 4);
                break;
            }
            case CONTINENTS: {
                biomesLayer = new GenLayerBiomeIslands(15L, biomesLayer, climateLayer, 60);
                break;
            }
        }
        biomesLayer = new GenLayerZoom(1000L, (GenLayer)biomesLayer);
        subBiomesInit = new GenLayerZoom(1000L, subBiomesInit);
        climateLayer = new GenLayerZoom(1000L, climateLayer);
        biomesLayer = new GenLayerBiomeEdgeBOP(1000L, biomesLayer);
        biomesLayer = new GenLayerSubBiomesBOP(1000L, biomesLayer, subBiomesInit);
        switch (settings.landScheme) {
            case ARCHIPELAGO: {
                biomesLayer = new GenLayerBiomeIslands(15L, biomesLayer, climateLayer, 8);
                break;
            }
            case CONTINENTS: {
                biomesLayer = new GenLayerBiomeIslands(15L, biomesLayer, climateLayer, 60);
                break;
            }
            default: {
                biomesLayer = new GenLayerBiomeIslands(15L, biomesLayer, climateLayer, 12);
            }
        }
        return biomesLayer;
    }

    public static GenLayer[] setupBOPGenLayers(long worldSeed, WorldTypeBOP worldType, BOPWorldSettings settings) {
        int biomeSize = settings.biomeSize.getValue();
        int riverSize = 4;
        GenLayer mainBranch = WorldChunkManagerBOP.initialLandAndSeaLayer(settings.landScheme);
        mainBranch = new GenLayerAddMushroomIsland(5L, mainBranch);
        mainBranch = new GenLayerLargeIsland(5L, mainBranch);
        mainBranch = new GenLayerDeepOcean(4L, mainBranch);
        GenLayerRiverInit riversAndSubBiomesInit = new GenLayerRiverInit(100L, mainBranch);
        GenLayer climateLayer = WorldChunkManagerBOP.climateLayer(settings, worldSeed);
        mainBranch = WorldChunkManagerBOP.allocateBiomes(worldSeed, worldType, settings, mainBranch, (GenLayer)riversAndSubBiomesInit, climateLayer);
        for (int i = 0; i < biomeSize; ++i) {
            mainBranch = new GenLayerZoom((long)(1000 + i), mainBranch);
            if (i == 0) {
                mainBranch = new GenLayerRaggedEdges(3L, mainBranch);
            }
            if (i != 1 && biomeSize != 1) continue;
            mainBranch = new GenLayerShoreBOP(1000L, mainBranch);
        }
        mainBranch = new GenLayerSmooth(1000L, mainBranch);
        GenLayer riversBranch = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)riversAndSubBiomesInit, (int)2);
        riversBranch = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)riversBranch, (int)riverSize);
        riversBranch = new GenLayerRiver(1L, riversBranch);
        riversBranch = new GenLayerSmooth(1000L, riversBranch);
        GenLayerRiverMixBOP riverMixFinal = new GenLayerRiverMixBOP(100L, mainBranch, riversBranch);
        GenLayerVoronoiZoom biomesFinal = new GenLayerVoronoiZoom(10L, (GenLayer)riverMixFinal);
        riverMixFinal.func_75905_a(worldSeed);
        biomesFinal.func_75905_a(worldSeed);
        return new GenLayer[]{riverMixFinal, biomesFinal, riverMixFinal};
    }
}

