/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class GeneratorColumns
extends GeneratorReplacing {
    protected int minHeight;
    protected int maxHeight;
    protected int generationAttempts;

    public GeneratorColumns(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int minHeight, int maxHeight, int generationAttempts) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.generationAttempts = generationAttempts;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        for (int i = 0; i < this.generationAttempts; ++i) {
            int targetHeight;
            BlockPos genPos = pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.placeOn.matches(world, genPos.func_177977_b()) || !this.replace.matches(world, genPos)) continue;
            for (int height = targetHeight = GeneratorUtils.nextIntBetween(rand, this.minHeight, this.maxHeight); height >= 0 && this.replace.matches(world, genPos); --height) {
                world.func_175656_a(genPos, this.with);
                genPos = genPos.func_177984_a();
            }
        }
        return true;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.with = conf.getBlockState("with", this.with);
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("maxHeight", this.maxHeight);
        this.generationAttempts = conf.getInt("generationAttempts", this.generationAttempts);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorColumns>
    implements IGenerator.IGeneratorBuilder<GeneratorColumns> {
        protected int minHeight;
        protected int maxHeight;
        protected int generationAttempts;

        public Builder minHeight(int a) {
            this.minHeight = a;
            return (Builder)this.self();
        }

        public Builder maxHeight(int a) {
            this.maxHeight = a;
            return (Builder)this.self();
        }

        public Builder generationAttempts(int a) {
            this.generationAttempts = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = new BlockQuery.BlockQueryMaterial(Material.field_151578_c, Material.field_151577_b);
            this.replace = BlockQueries.airOrLeaves;
            this.with = Blocks.field_150347_e.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
            this.minHeight = 2;
            this.maxHeight = 4;
            this.generationAttempts = 12;
        }

        @Override
        public GeneratorColumns create() {
            return new GeneratorColumns(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.minHeight, this.maxHeight, this.generationAttempts);
        }
    }
}

