/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class GeneratorSpike
extends GeneratorReplacing {
    protected int minHeight;
    protected int maxHeight;
    protected int minRadius;
    protected int maxRadius;

    public GeneratorSpike(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int minHeight, int maxHeight, int minRadius, int maxRadius) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        int maxRadius = this.minRadius + rand.nextInt(this.maxRadius - this.minRadius + 1);
        int centreHeight = this.minHeight + rand.nextInt(this.maxHeight - this.minHeight + 1);
        if (!this.canPlaceHere(world, position, centreHeight, maxRadius)) {
            return false;
        }
        int layerHeight = centreHeight / (maxRadius - 1);
        this.createCircleWithChance(world, position, this.with, maxRadius - 1, true, 1.0f);
        this.createCircleWithChance(world, position, this.with, maxRadius, true, 0.15f);
        BlockPos layerStartPos = position.func_177984_a();
        for (int y = 0; y <= centreHeight + 2; ++y) {
            if (y > centreHeight) {
                world.func_175656_a(layerStartPos.func_177982_a(0, y, 0), this.with);
                continue;
            }
            int layer = y / layerHeight;
            int layerIndex = y % layerHeight;
            int radius = maxRadius - 1 - layer;
            if (radius == 0) {
                world.func_175656_a(layerStartPos.func_177982_a(0, y, 0), this.with);
                continue;
            }
            if (layerIndex == layerHeight - 1) {
                this.createCircleWithChance(world, layerStartPos.func_177982_a(0, y, 0), this.with, radius - 1, true, 1.0f);
                this.createMidpointsWithChance(world, layerStartPos.func_177982_a(0, y, 0), this.with, radius, 0.7f);
                continue;
            }
            if (layerIndex == layerHeight - 2) {
                this.createCircleWithChance(world, layerStartPos.func_177982_a(0, y, 0), this.with, radius - 1, true, 1.0f);
                this.createCircleWithChance(world, layerStartPos.func_177982_a(0, y, 0), this.with, radius, true, 0.1f / (float)(layer + 1));
                continue;
            }
            this.createCircleWithChance(world, layerStartPos.func_177982_a(0, y, 0), this.with, radius, true, 1.0f);
        }
        return true;
    }

    public boolean canPlaceHere(World world, BlockPos pos, int height, int radius) {
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + height > 255) {
            return false;
        }
        for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + height; ++y) {
            for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                    if (y == pos.func_177956_o() && !this.placeOn.matches(world, new BlockPos(x, y - 1, z))) {
                        return false;
                    }
                    if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.placeOn = conf.getBlockPosQuery("placeUnder", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.with = conf.getBlockState("with", this.with);
        this.scatterYMethod = conf.getEnum("scatterYMethod", this.scatterYMethod, GeneratorUtils.ScatterYMethod.class);
        int minHeight = conf.getInt("minHeight", this.minHeight);
        int maxHeight = conf.getInt("maxHeight", this.maxHeight);
        Pair<Integer, Integer> heights = GeneratorUtils.validateMinMaxHeight(minHeight, maxHeight);
        this.minHeight = (Integer)heights.getLeft();
        this.maxHeight = (Integer)heights.getRight();
        int minRadius = conf.getInt("minRadius", this.minRadius);
        int maxRadius = conf.getInt("maxRadius", this.maxRadius);
        Pair<Integer, Integer> radii = GeneratorUtils.validateMinMaxHeight(minRadius, maxRadius);
        this.minRadius = (Integer)radii.getLeft();
        this.maxRadius = (Integer)radii.getRight();
    }

    private void createCircleWithChance(World world, BlockPos middle, IBlockState state, int maxRadius, boolean fill, float chance) {
        double increment = 0.05;
        for (int radius = maxRadius; radius >= 0; --radius) {
            for (double angle = 0.0; angle <= Math.PI * 2; angle += increment) {
                BlockPos pos = middle.func_177963_a((double)Math.round((double)radius * Math.cos(angle)), 0.0, (double)Math.round((double)radius * Math.sin(angle)));
                this.setBlockWithChance(world, pos, state, chance);
            }
            if (!fill) break;
        }
    }

    private void createMidpointsWithChance(World world, BlockPos middle, IBlockState state, int radius, float chance) {
        BlockPos midpoint = middle.func_177982_a(-radius, 0, 0);
        if (world.func_180495_p(midpoint.func_177977_b()) == state) {
            this.setBlockWithChance(world, midpoint, state, chance);
        }
        if (world.func_180495_p((midpoint = middle.func_177982_a(radius, 0, 0)).func_177977_b()) == state) {
            this.setBlockWithChance(world, midpoint, state, chance);
        }
        if (world.func_180495_p((midpoint = middle.func_177982_a(0, 0, -radius)).func_177977_b()) == state) {
            this.setBlockWithChance(world, midpoint, state, chance);
        }
        if (world.func_180495_p((midpoint = middle.func_177982_a(0, 0, radius)).func_177977_b()) == state) {
            this.setBlockWithChance(world, midpoint, state, chance);
        }
    }

    private void setBlockWithChance(World world, BlockPos pos, IBlockState state, float chance) {
        if (world.field_73012_v.nextFloat() < chance) {
            world.func_175656_a(pos, state);
        }
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorSpike>
    implements IGenerator.IGeneratorBuilder<GeneratorSpike> {
        protected int minHeight;
        protected int maxHeight;
        protected int minRadius;
        protected int maxRadius;

        public Builder minHeight(int a) {
            this.minHeight = a;
            return (Builder)this.self();
        }

        public Builder maxHeight(int a) {
            this.maxHeight = a;
            return (Builder)this.self();
        }

        public Builder minRadius(int a) {
            this.minRadius = a;
            return (Builder)this.self();
        }

        public Builder maxRadius(int a) {
            this.maxRadius = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.solid;
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a);
            this.with = BOPBlocks.dried_sand.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
            this.minHeight = 8;
            this.maxHeight = 12;
            this.minRadius = 3;
            this.maxRadius = 3;
        }

        @Override
        public GeneratorSpike create() {
            return new GeneratorSpike(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.minHeight, this.maxHeight, this.minRadius, this.maxRadius);
        }
    }
}

