/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class GeneratorSplatter
extends GeneratorReplacing {
    protected int generationAttempts;

    public GeneratorSplatter(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int generationAttempts) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.generationAttempts = generationAttempts;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        for (int i = 0; i < this.generationAttempts; ++i) {
            BlockPos pos1 = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!this.replace.matches(world, pos1) || !this.placeOn.matches(world, pos1.func_177977_b())) continue;
            world.func_175656_a(pos1, this.with);
        }
        return true;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.with = conf.getBlockState("with", this.with);
        this.generationAttempts = conf.getInt("generationAttempts", this.generationAttempts);
        this.scatterYMethod = conf.getEnum("scatterYMethod", this.scatterYMethod, GeneratorUtils.ScatterYMethod.class);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorSplatter>
    implements IGenerator.IGeneratorBuilder<GeneratorSplatter> {
        protected int generationAttempts;

        public Builder generationAttempts(int a) {
            this.generationAttempts = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.anything;
            this.replace = BlockQueries.breakable;
            this.with = Blocks.field_150348_b.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
            this.generationAttempts = 64;
        }

        @Override
        public GeneratorSplatter create() {
            return new GeneratorSplatter(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.generationAttempts);
        }
    }
}

