/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature.tree;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneratorPineTree
extends GeneratorTreeBase {
    public GeneratorPineTree(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState altLeaves, int minHeight, int maxHeight) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, altLeaves, minHeight, maxHeight);
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int i;
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().isLeaves((IBlockAccess)world, pos)) {
            pos = pos.func_177977_b();
        }
        if (!this.placeOn.matches(world, pos)) {
            return false;
        }
        int height = GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight);
        if (height < 6) {
            return false;
        }
        int heightMinusTop = height - 3;
        int numBranches = heightMinusTop / 3;
        int baseHeight = heightMinusTop - numBranches * 2;
        if (!this.checkSpace(world, pos = pos.func_177984_a(), baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.setLog(world, pos);
            pos = pos.func_177984_a();
        }
        for (i = 0; i < numBranches; ++i) {
            this.generateLeafLayer(world, random, pos, i);
            pos = pos.func_177981_b(2);
        }
        this.generateTop(world, pos);
        return true;
    }

    public boolean checkSpace(World world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateTop(World world, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                this.setLeaves(world, pos.func_177982_a(x, 0, z));
            }
        }
        this.setLog(world, pos);
        pos = pos.func_177984_a();
        this.setLeaves(world, pos);
        this.setLeaves(world, pos.func_177978_c());
        this.setLeaves(world, pos.func_177974_f());
        this.setLeaves(world, pos.func_177968_d());
        this.setLeaves(world, pos.func_177976_e());
        this.setLeaves(world, pos.func_177984_a());
    }

    public void generateBranch(World world, BlockPos pos, EnumFacing direction, boolean dropY, boolean dropCorner) {
        EnumFacing sideways = direction.func_176746_e();
        if (dropY) {
            pos = pos.func_177977_b();
        }
        this.setLeaves(world, pos.func_177967_a(direction, 1).func_177967_a(sideways, 1));
        this.setLeaves(world, pos.func_177967_a(direction, 2).func_177967_a(sideways, 1));
        this.setLeaves(world, pos.func_177967_a(direction, 1).func_177967_a(sideways, 2));
        this.setLeaves(world, pos.func_177967_a(direction, 2).func_177967_a(sideways, 2));
        if (dropCorner) {
            this.setLeaves(world, pos.func_177967_a(direction, 2).func_177967_a(sideways, 2).func_177977_b());
        }
    }

    public void generateLeafLayer(World world, Random rand, BlockPos pos, int leafLayerNum) {
        boolean dropCorner;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                this.setLeaves(world, pos.func_177982_a(x, 0, z));
            }
        }
        EnumFacing direction = leafLayerNum % 2 == 0 ? EnumFacing.NORTH : EnumFacing.EAST;
        boolean dropY = rand.nextInt(2) == 0;
        boolean bl = dropCorner = rand.nextInt(2) == 0;
        if (rand.nextInt(2) == 0) {
            this.generateBranch(world, pos, direction, dropY, dropCorner);
        }
        if (rand.nextInt(2) == 0) {
            this.generateBranch(world, pos, direction.func_176734_d(), dropY, dropCorner);
        }
        this.setLog(world, pos);
        this.setLog(world, pos.func_177984_a());
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("minHeight", this.maxHeight);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorPineTree>
    implements IGenerator.IGeneratorBuilder<GeneratorPineTree> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 6;
            this.maxHeight = 12;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P();
            this.vine = null;
            this.hanging = this.hanging;
            this.altLeaves = null;
        }

        @Override
        public GeneratorPineTree create() {
            return new GeneratorPineTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.altLeaves, this.minHeight, this.maxHeight);
        }
    }
}

