/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.feature.tree;

import biomesoplenty.api.biome.generation.IGenerator;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.feature.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneratorTwigletTree
extends GeneratorTreeBase {
    private float leafChanceEven;
    private float leafChanceOdd;

    public GeneratorTwigletTree(float amountPerChunk, BlockQuery.IBlockPosQuery placeOn, BlockQuery.IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState altLeaves, int minHeight, int maxHeight, float leafChanceEven, float leafChanceOdd) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, altLeaves, minHeight, maxHeight);
        this.leafChanceEven = leafChanceEven;
        this.leafChanceOdd = leafChanceOdd;
    }

    public boolean func_180709_b(World world, Random random, BlockPos startPos) {
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_177230_c().isLeaves((IBlockAccess)world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = this.minHeight + random.nextInt(1 + this.maxHeight - this.minHeight);
        int baseHeight = height / 3;
        BlockPos pos = startPos.func_177984_a();
        for (int y = 0; y < height; ++y) {
            float leafChance;
            if (!this.setLog(world, pos.func_177981_b(y))) {
                return true;
            }
            float f = leafChance = (height - y) % 2 == 0 ? this.leafChanceEven : this.leafChanceOdd;
            if (y <= baseHeight) continue;
            if (random.nextFloat() < leafChance) {
                this.setLeaves(world, pos.func_177982_a(1, y, 0));
            }
            if (random.nextFloat() < leafChance) {
                this.setLeaves(world, pos.func_177982_a(-1, y, 0));
            }
            if (random.nextFloat() < leafChance) {
                this.setLeaves(world, pos.func_177982_a(0, y, 1));
            }
            if (!(random.nextFloat() < leafChance)) continue;
            this.setLeaves(world, pos.func_177982_a(0, y, -1));
        }
        this.setLeaves(world, pos.func_177982_a(0, height, 0));
        return true;
    }

    @Override
    public void configure(BOPConfig.IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("maxHeight", this.maxHeight);
        this.leafChanceEven = conf.getFloat("leafChance", Float.valueOf(this.leafChanceEven)).floatValue();
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorTwigletTree>
    implements IGenerator.IGeneratorBuilder<GeneratorTwigletTree> {
        protected float leafChanceEven;
        protected float leafChanceOdd;

        public Builder leafChance(float a) {
            this.leafChanceEven = a;
            this.leafChanceOdd = a;
            return (Builder)this.self();
        }

        public Builder leafChance(float a, float b) {
            this.leafChanceEven = a;
            this.leafChanceOdd = b;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 2;
            this.maxHeight = 6;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P();
            this.vine = null;
            this.hanging = null;
            this.altLeaves = null;
            this.leafChanceEven = 0.2f;
            this.leafChanceOdd = 0.9f;
        }

        @Override
        public GeneratorTwigletTree create() {
            return new GeneratorTwigletTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.altLeaves, this.minHeight, this.maxHeight, this.leafChanceEven, this.leafChanceOdd);
        }
    }
}

