/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.api.block.IBOPBlock;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.api.particle.BOPParticleTypes;
import biomesoplenty.client.particle.EntityPixieTrailFX;
import biomesoplenty.client.particle.EntityTrailFX;
import biomesoplenty.client.texture.ForgeRedirectedResourcePack;
import biomesoplenty.common.config.MiscConfigurationHandler;
import biomesoplenty.common.entities.EntityButterfly;
import biomesoplenty.common.entities.EntityPixie;
import biomesoplenty.common.entities.EntitySnail;
import biomesoplenty.common.entities.EntityWasp;
import biomesoplenty.common.entities.RenderButterfly;
import biomesoplenty.common.entities.RenderPixie;
import biomesoplenty.common.entities.RenderSnail;
import biomesoplenty.common.entities.RenderWasp;
import biomesoplenty.common.entities.projectiles.EntityDart;
import biomesoplenty.common.entities.projectiles.EntityMudball;
import biomesoplenty.common.entities.projectiles.RenderDart;
import biomesoplenty.common.entities.projectiles.RenderMudball;
import biomesoplenty.core.CommonProxy;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ClientProxy
extends CommonProxy {
    public static ResourceLocation[] bopTitlePanoramaPaths = new ResourceLocation[]{new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_0.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_1.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_2.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_3.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_4.png"), new ResourceLocation("biomesoplenty:textures/gui/title/background/panorama_5.png")};
    public static ResourceLocation particleTexturesLocation = new ResourceLocation("biomesoplenty:textures/particles/particles.png");

    @Override
    public void registerRenderers() {
        if (MiscConfigurationHandler.overrideTitlePanorama) {
            GuiMainMenu.field_73978_o = bopTitlePanoramaPaths;
        }
        ClientProxy.registerEntityRenderer(EntityDart.class, RenderDart.class);
        ClientProxy.registerEntityRenderer(EntityWasp.class, RenderWasp.class);
        ClientProxy.registerEntityRenderer(EntityPixie.class, RenderPixie.class);
        ClientProxy.registerEntityRenderer(EntitySnail.class, RenderSnail.class);
        ClientProxy.registerEntityRenderer(EntityButterfly.class, RenderButterfly.class);
        ClientProxy.registerEntityRenderer(EntityMudball.class, RenderMudball.class);
        ClientProxy.replaceForgeResources();
    }

    @Override
    public void registerItemVariantModel(Item item, String name, int metadata) {
        if (item != null) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("biomesoplenty:" + name)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("BiomesOPlenty:" + name, "inventory"));
        }
    }

    @Override
    public void registerNonRenderingProperties(Block block) {
        IBOPBlock bopBlock;
        IProperty[] nonRenderingProperties;
        if (block instanceof IBOPBlock && (nonRenderingProperties = (bopBlock = (IBOPBlock)block).getNonRenderingProperties()) != null) {
            StateMap custom_mapper = new StateMap.Builder().func_178442_a(nonRenderingProperties).func_178441_a();
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)custom_mapper);
        }
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("BiomesOPlenty".toLowerCase() + ":fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @Override
    public void spawnParticle(BOPParticleTypes type, double x, double y, double z, Object ... info) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityFX entityFx = null;
        switch (type) {
            case PIXIETRAIL: {
                entityFx = new EntityPixieTrailFX((World)minecraft.field_71441_e, x, y, z, MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.03, (double)0.03), -0.02, MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.03, (double)0.03));
                break;
            }
            case MUD: {
                int itemId = Item.func_150891_b((Item)BOPItems.mudball);
                minecraft.field_71441_e.func_175688_a(EnumParticleTypes.ITEM_CRACK, x, y, z, MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.08, (double)0.08), MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.08, (double)0.08), MathHelper.func_82716_a((Random)minecraft.field_71441_e.field_73012_v, (double)-0.08, (double)0.08), new int[]{itemId});
                return;
            }
            case PLAYER_TRAIL: {
                if (info.length < 1) {
                    throw new RuntimeException("Missing argument for trail name!");
                }
                entityFx = new EntityTrailFX((World)minecraft.field_71441_e, x, y, z, (String)info[0]);
                break;
            }
        }
        if (entityFx != null) {
            minecraft.field_71452_i.func_78873_a(entityFx);
        }
    }

    private static void replaceForgeResources() {
        if (ForgeModContainer.replaceVanillaBucketModel && MiscConfigurationHandler.overrideForgeBuckets) {
            FMLClientHandler clientHandler = FMLClientHandler.instance();
            List resourcePackList = (List)ReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)clientHandler, (String[])new String[]{"resourcePackList"});
            Map resourcePackMap = (Map)ReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)clientHandler, (String[])new String[]{"resourcePackMap"});
            AbstractResourcePack resourcePack = (AbstractResourcePack)clientHandler.getResourcePackFor("Forge");
            resourcePackList.remove(resourcePack);
            resourcePackMap.remove("Forge");
            ForgeRedirectedResourcePack redirectedResourcePack = new ForgeRedirectedResourcePack(FMLCommonHandler.instance().findContainerFor((Object)"Forge"));
            resourcePackList.add(redirectedResourcePack);
            resourcePackMap.put("Forge", redirectedResourcePack);
        }
    }

    private static <E extends Entity> void registerEntityRenderer(Class<E> entityClass, Class<? extends Render<E>> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new EntityRenderFactory(renderClass));
    }

    private static class EntityRenderFactory<E extends Entity>
    implements IRenderFactory<E> {
        private Class<? extends Render<E>> renderClass;

        private EntityRenderFactory(Class<? extends Render<E>> renderClass) {
            this.renderClass = renderClass;
        }

        public Render<E> createRenderFor(RenderManager manager) {
            Render<E> renderer = null;
            try {
                renderer = this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return renderer;
        }
    }
}

