/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.blocks.renderers;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static int foliageModel = -1;
    public static int plantsModel = -1;
    public static int puddleModel = -1;
    public static int bonesModel = -1;
    public static int graveModel = -1;
    public static int bambooModel = -1;
    public static int colorizedLeavesModel = -1;
    public static int leavesModel = -1;

    public static void renderStandardInvBlock(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_78613_a(block, 0.0, 0.0, 0.0, block.func_71858_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_78617_b(block, 0.0, 0.0, 0.0, block.func_71858_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_78611_c(block, 0.0, 0.0, 0.0, block.func_71858_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_78622_d(block, 0.0, 0.0, 0.0, block.func_71858_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_78573_e(block, 0.0, 0.0, 0.0, block.func_71858_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_78605_f(block, 0.0, 0.0, 0.0, block.func_71858_a(5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void renderCrossedSquaresFromIcon(Icon icon, double par3, double par5, double par7, float par9, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_94167_b()) {
            icon = renderer.field_78664_d;
        }
        double d3 = icon.func_94209_e();
        double d4 = icon.func_94206_g();
        double d5 = icon.func_94212_f();
        double d6 = icon.func_94210_h();
        double d7 = 0.45 * (double)par9;
        double d8 = par3 + 0.5 - d7;
        double d9 = par3 + 0.5 + d7;
        double d10 = par7 + 0.5 - d7;
        double d11 = par7 + 0.5 + d7;
        tessellator.func_78374_a(d8, par5 + (double)par9, d10, d3, d4);
        tessellator.func_78374_a(d8, par5 + 0.0, d10, d3, d6);
        tessellator.func_78374_a(d9, par5 + 0.0, d11, d5, d6);
        tessellator.func_78374_a(d9, par5 + (double)par9, d11, d5, d4);
        tessellator.func_78374_a(d9, par5 + (double)par9, d11, d3, d4);
        tessellator.func_78374_a(d9, par5 + 0.0, d11, d3, d6);
        tessellator.func_78374_a(d8, par5 + 0.0, d10, d5, d6);
        tessellator.func_78374_a(d8, par5 + (double)par9, d10, d5, d4);
        tessellator.func_78374_a(d8, par5 + (double)par9, d11, d3, d4);
        tessellator.func_78374_a(d8, par5 + 0.0, d11, d3, d6);
        tessellator.func_78374_a(d9, par5 + 0.0, d10, d5, d6);
        tessellator.func_78374_a(d9, par5 + (double)par9, d10, d5, d4);
        tessellator.func_78374_a(d9, par5 + (double)par9, d10, d3, d4);
        tessellator.func_78374_a(d9, par5 + 0.0, d10, d3, d6);
        tessellator.func_78374_a(d8, par5 + 0.0, d11, d5, d6);
        tessellator.func_78374_a(d8, par5 + (double)par9, d11, d5, d4);
    }

    public static boolean renderFace(RenderBlocks renderer, Block block, Icon icon, IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return RenderUtils.renderFace(renderer, block, icon, world, x, y, z, -1, face);
    }

    public static boolean renderFace(RenderBlocks renderer, Block block, Icon icon, IBlockAccess world, int x, int y, int z, int brightness, ForgeDirection face) {
        if (icon == null) {
            return false;
        }
        int color = block.func_71920_b(renderer.field_78669_a, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float redA = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            float greenA = (red * 30.0f + green * 70.0f) / 100.0f;
            float blueA = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = redA;
            green = greenA;
            blue = blueA;
        }
        if (Minecraft.func_71379_u()) {
            return RenderUtils.renderFaceWithAmbientOcclusion(renderer, block, icon, world, x, y, z, red, green, blue, brightness, face);
        }
        return RenderUtils.renderFaceWithColorMultiplier(renderer, block, world, icon, x, y, z, red, green, blue, brightness, face);
    }

    private static boolean renderFaceWithAmbientOcclusion(RenderBlocks renderer, Block block, Icon icon, IBlockAccess world, int x, int y, int z, float r, float g, float b, int brightness, ForgeDirection face) {
        float lightValue;
        int mixedBrightnessForSide;
        boolean grassYZNN;
        boolean grassYZNP;
        boolean grassXYNN;
        boolean grassXYPN;
        renderer.field_78677_m = true;
        boolean renderedFace = false;
        boolean brightFlag = brightness > -1;
        float colorModTopLeft = 0.0f;
        float colorModBottomLeft = 0.0f;
        float colorModBottomRight = 0.0f;
        float colorModTopRight = 0.0f;
        boolean locationColorFlag = true;
        int mixedBrightnessForBlock = block.func_71874_e(renderer.field_78669_a, x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(983055);
        if (renderer.func_94175_b(block).func_94215_i().equals("grass_top")) {
            locationColorFlag = false;
        } else if (renderer.func_94167_b()) {
            locationColorFlag = false;
        }
        if (face == ForgeDirection.DOWN && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x, y - 1, z, 0))) {
            if (renderer.field_83027_i <= 0.0) {
                --y;
            }
            renderer.field_78641_T = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x - 1, y, z);
            renderer.field_78645_V = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x, y, z - 1);
            renderer.field_78643_W = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x, y, z + 1);
            renderer.field_78655_Y = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x + 1, y, z);
            renderer.field_78689_v = block.func_71888_h(renderer.field_78669_a, x - 1, y, z);
            renderer.field_78712_x = block.func_71888_h(renderer.field_78669_a, x, y, z - 1);
            renderer.field_78710_y = block.func_71888_h(renderer.field_78669_a, x, y, z + 1);
            renderer.field_78628_A = block.func_71888_h(renderer.field_78669_a, x + 1, y, z);
            grassXYPN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x + 1, y - 1, z)];
            grassXYNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x - 1, y - 1, z)];
            grassYZNP = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x, y - 1, z + 1)];
            grassYZNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x, y - 1, z - 1)];
            if (!grassYZNN && !grassXYNN) {
                renderer.field_78691_u = renderer.field_78689_v;
                renderer.field_78649_S = brightFlag ? brightness : renderer.field_78641_T;
            } else {
                renderer.field_78691_u = block.func_71888_h(renderer.field_78669_a, x - 1, y, z - 1);
                int n = renderer.field_78649_S = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x - 1, y, z - 1);
            }
            if (!grassYZNP && !grassXYNN) {
                renderer.field_78687_w = renderer.field_78689_v;
                renderer.field_78639_U = brightFlag ? brightness : renderer.field_78641_T;
            } else {
                renderer.field_78687_w = block.func_71888_h(renderer.field_78669_a, x - 1, y, z + 1);
                int n = renderer.field_78639_U = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x - 1, y, z + 1);
            }
            if (!grassYZNN && !grassXYPN) {
                renderer.field_78708_z = renderer.field_78628_A;
                renderer.field_78657_X = brightFlag ? brightness : renderer.field_78655_Y;
            } else {
                renderer.field_78708_z = block.func_71888_h(renderer.field_78669_a, x + 1, y, z - 1);
                int n = renderer.field_78657_X = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x + 1, y, z - 1);
            }
            if (!grassYZNP && !grassXYPN) {
                renderer.field_78629_B = renderer.field_78628_A;
                renderer.field_78660_Z = brightFlag ? brightness : renderer.field_78655_Y;
            } else {
                renderer.field_78629_B = block.func_71888_h(renderer.field_78669_a, x + 1, y, z + 1);
                int n = renderer.field_78660_Z = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x + 1, y, z + 1);
            }
            if (renderer.field_83027_i <= 0.0) {
                ++y;
            }
            mixedBrightnessForSide = mixedBrightnessForBlock;
            if (renderer.field_83027_i <= 0.0 || !renderer.field_78669_a.func_72804_r(x, y - 1, z)) {
                mixedBrightnessForSide = brightFlag ? brightness : block.func_71874_e(renderer.field_78669_a, x, y - 1, z);
            }
            lightValue = block.func_71888_h(renderer.field_78669_a, x, y - 1, z);
            colorModTopLeft = (renderer.field_78687_w + renderer.field_78689_v + renderer.field_78710_y + lightValue) / 4.0f;
            colorModTopRight = (renderer.field_78710_y + lightValue + renderer.field_78629_B + renderer.field_78628_A) / 4.0f;
            colorModBottomRight = (lightValue + renderer.field_78712_x + renderer.field_78628_A + renderer.field_78708_z) / 4.0f;
            colorModBottomLeft = (renderer.field_78689_v + renderer.field_78691_u + lightValue + renderer.field_78712_x) / 4.0f;
            renderer.field_78700_an = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78639_U, renderer.field_78641_T, renderer.field_78643_W, mixedBrightnessForSide);
            renderer.field_78676_aq = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78643_W, renderer.field_78660_Z, renderer.field_78655_Y, mixedBrightnessForSide);
            renderer.field_78696_ap = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78645_V, renderer.field_78655_Y, renderer.field_78657_X, mixedBrightnessForSide);
            int n = renderer.field_78694_ao = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78641_T, renderer.field_78649_S, renderer.field_78645_V, mixedBrightnessForSide);
            if (locationColorFlag) {
                renderer.field_78670_at = renderer.field_78684_au = r * 0.5f;
                renderer.field_78672_as = renderer.field_78684_au;
                renderer.field_78674_ar = renderer.field_78684_au;
                renderer.field_78678_ax = renderer.field_78665_ay = g * 0.5f;
                renderer.field_78680_aw = renderer.field_78665_ay;
                renderer.field_78682_av = renderer.field_78665_ay;
                renderer.field_78651_aB = renderer.field_78652_aC = b * 0.5f;
                renderer.field_78650_aA = renderer.field_78652_aC;
                renderer.field_78663_az = renderer.field_78652_aC;
            } else {
                renderer.field_78684_au = 0.5f;
                renderer.field_78670_at = 0.5f;
                renderer.field_78672_as = 0.5f;
                renderer.field_78674_ar = 0.5f;
                renderer.field_78665_ay = 0.5f;
                renderer.field_78678_ax = 0.5f;
                renderer.field_78680_aw = 0.5f;
                renderer.field_78682_av = 0.5f;
                renderer.field_78652_aC = 0.5f;
                renderer.field_78651_aB = 0.5f;
                renderer.field_78650_aA = 0.5f;
                renderer.field_78663_az = 0.5f;
            }
            renderer.field_78674_ar *= colorModTopLeft;
            renderer.field_78682_av *= colorModTopLeft;
            renderer.field_78663_az *= colorModTopLeft;
            renderer.field_78672_as *= colorModBottomLeft;
            renderer.field_78680_aw *= colorModBottomLeft;
            renderer.field_78650_aA *= colorModBottomLeft;
            renderer.field_78670_at *= colorModBottomRight;
            renderer.field_78678_ax *= colorModBottomRight;
            renderer.field_78651_aB *= colorModBottomRight;
            renderer.field_78684_au *= colorModTopRight;
            renderer.field_78665_ay *= colorModTopRight;
            renderer.field_78652_aC *= colorModTopRight;
            renderer.func_78613_a(block, (double)x, (double)y, (double)z, icon);
            renderedFace = true;
        }
        if (face == ForgeDirection.UP && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x, y + 1, z, 1))) {
            if (renderer.field_83024_j >= 1.0) {
                ++y;
            }
            renderer.field_78705_ab = block.func_71874_e(renderer.field_78669_a, x - 1, y, z);
            renderer.field_78711_af = block.func_71874_e(renderer.field_78669_a, x + 1, y, z);
            renderer.field_78703_ad = block.func_71874_e(renderer.field_78669_a, x, y, z - 1);
            renderer.field_78706_ag = block.func_71874_e(renderer.field_78669_a, x, y, z + 1);
            renderer.field_78624_D = block.func_71888_h(renderer.field_78669_a, x - 1, y, z);
            renderer.field_78634_H = block.func_71888_h(renderer.field_78669_a, x + 1, y, z);
            renderer.field_78626_F = block.func_71888_h(renderer.field_78669_a, x, y, z - 1);
            renderer.field_78635_I = block.func_71888_h(renderer.field_78669_a, x, y, z + 1);
            grassXYPN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x + 1, y + 1, z)];
            grassXYNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x - 1, y + 1, z)];
            grassYZNP = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x, y + 1, z + 1)];
            grassYZNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x, y + 1, z - 1)];
            if (!grassYZNN && !grassXYNN) {
                renderer.field_78630_C = renderer.field_78624_D;
                renderer.field_78704_aa = renderer.field_78705_ab;
            } else {
                renderer.field_78630_C = block.func_71888_h(renderer.field_78669_a, x - 1, y, z - 1);
                renderer.field_78704_aa = block.func_71874_e(renderer.field_78669_a, x - 1, y, z - 1);
            }
            if (!grassYZNN && !grassXYPN) {
                renderer.field_78627_G = renderer.field_78634_H;
                renderer.field_78709_ae = renderer.field_78711_af;
            } else {
                renderer.field_78627_G = block.func_71888_h(renderer.field_78669_a, x + 1, y, z - 1);
                renderer.field_78709_ae = block.func_71874_e(renderer.field_78669_a, x + 1, y, z - 1);
            }
            if (!grassYZNP && !grassXYNN) {
                renderer.field_78625_E = renderer.field_78624_D;
                renderer.field_78702_ac = renderer.field_78705_ab;
            } else {
                renderer.field_78625_E = block.func_71888_h(renderer.field_78669_a, x - 1, y, z + 1);
                renderer.field_78702_ac = block.func_71874_e(renderer.field_78669_a, x - 1, y, z + 1);
            }
            if (!grassYZNP && !grassXYPN) {
                renderer.field_78636_J = renderer.field_78634_H;
                renderer.field_78707_ah = renderer.field_78711_af;
            } else {
                renderer.field_78636_J = block.func_71888_h(renderer.field_78669_a, x + 1, y, z + 1);
                renderer.field_78707_ah = block.func_71874_e(renderer.field_78669_a, x + 1, y, z + 1);
            }
            if (renderer.field_83024_j >= 1.0) {
                --y;
            }
            mixedBrightnessForSide = mixedBrightnessForBlock;
            if (renderer.field_83024_j >= 1.0 || !renderer.field_78669_a.func_72804_r(x, y + 1, z)) {
                mixedBrightnessForSide = block.func_71874_e(renderer.field_78669_a, x, y + 1, z);
            }
            lightValue = block.func_71888_h(renderer.field_78669_a, x, y + 1, z);
            colorModTopRight = (renderer.field_78625_E + renderer.field_78624_D + renderer.field_78635_I + lightValue) / 4.0f;
            colorModTopLeft = (renderer.field_78635_I + lightValue + renderer.field_78636_J + renderer.field_78634_H) / 4.0f;
            colorModBottomLeft = (lightValue + renderer.field_78626_F + renderer.field_78634_H + renderer.field_78627_G) / 4.0f;
            colorModBottomRight = (renderer.field_78624_D + renderer.field_78630_C + lightValue + renderer.field_78626_F) / 4.0f;
            renderer.field_78676_aq = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78702_ac, renderer.field_78705_ab, renderer.field_78706_ag, mixedBrightnessForSide);
            renderer.field_78700_an = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78706_ag, renderer.field_78707_ah, renderer.field_78711_af, mixedBrightnessForSide);
            renderer.field_78694_ao = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78703_ad, renderer.field_78711_af, renderer.field_78709_ae, mixedBrightnessForSide);
            renderer.field_78696_ap = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78705_ab, renderer.field_78704_aa, renderer.field_78703_ad, mixedBrightnessForSide);
            renderer.field_78670_at = renderer.field_78684_au = r;
            renderer.field_78672_as = renderer.field_78684_au;
            renderer.field_78674_ar = renderer.field_78684_au;
            renderer.field_78678_ax = renderer.field_78665_ay = g;
            renderer.field_78680_aw = renderer.field_78665_ay;
            renderer.field_78682_av = renderer.field_78665_ay;
            renderer.field_78651_aB = renderer.field_78652_aC = b;
            renderer.field_78650_aA = renderer.field_78652_aC;
            renderer.field_78663_az = renderer.field_78652_aC;
            renderer.field_78674_ar *= colorModTopLeft;
            renderer.field_78682_av *= colorModTopLeft;
            renderer.field_78663_az *= colorModTopLeft;
            renderer.field_78672_as *= colorModBottomLeft;
            renderer.field_78680_aw *= colorModBottomLeft;
            renderer.field_78650_aA *= colorModBottomLeft;
            renderer.field_78670_at *= colorModBottomRight;
            renderer.field_78678_ax *= colorModBottomRight;
            renderer.field_78651_aB *= colorModBottomRight;
            renderer.field_78684_au *= colorModTopRight;
            renderer.field_78665_ay *= colorModTopRight;
            renderer.field_78652_aC *= colorModTopRight;
            renderer.func_78617_b(block, (double)x, (double)y, (double)z, icon);
            renderedFace = true;
        }
        if (face == ForgeDirection.NORTH && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x, y, z - 1, 2))) {
            if (renderer.field_83025_k <= 0.0) {
                --z;
            }
            renderer.field_78637_K = block.func_71888_h(renderer.field_78669_a, x - 1, y, z);
            renderer.field_78712_x = block.func_71888_h(renderer.field_78669_a, x, y - 1, z);
            renderer.field_78626_F = block.func_71888_h(renderer.field_78669_a, x, y + 1, z);
            renderer.field_78631_L = block.func_71888_h(renderer.field_78669_a, x + 1, y, z);
            renderer.field_78690_ai = block.func_71874_e(renderer.field_78669_a, x - 1, y, z);
            renderer.field_78645_V = block.func_71874_e(renderer.field_78669_a, x, y - 1, z);
            renderer.field_78703_ad = block.func_71874_e(renderer.field_78669_a, x, y + 1, z);
            renderer.field_78692_aj = block.func_71874_e(renderer.field_78669_a, x + 1, y, z);
            grassXYPN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x + 1, y, z - 1)];
            grassXYNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x - 1, y, z - 1)];
            grassYZNP = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x, y + 1, z - 1)];
            grassYZNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x, y - 1, z - 1)];
            if (!grassXYNN && !grassYZNN) {
                renderer.field_78691_u = renderer.field_78637_K;
                renderer.field_78649_S = renderer.field_78690_ai;
            } else {
                renderer.field_78691_u = block.func_71888_h(renderer.field_78669_a, x - 1, y - 1, z);
                renderer.field_78649_S = block.func_71874_e(renderer.field_78669_a, x - 1, y - 1, z);
            }
            if (!grassXYNN && !grassYZNP) {
                renderer.field_78630_C = renderer.field_78637_K;
                renderer.field_78704_aa = renderer.field_78690_ai;
            } else {
                renderer.field_78630_C = block.func_71888_h(renderer.field_78669_a, x - 1, y + 1, z);
                renderer.field_78704_aa = block.func_71874_e(renderer.field_78669_a, x - 1, y + 1, z);
            }
            if (!grassXYPN && !grassYZNN) {
                renderer.field_78708_z = renderer.field_78631_L;
                renderer.field_78657_X = renderer.field_78692_aj;
            } else {
                renderer.field_78708_z = block.func_71888_h(renderer.field_78669_a, x + 1, y - 1, z);
                renderer.field_78657_X = block.func_71874_e(renderer.field_78669_a, x + 1, y - 1, z);
            }
            if (!grassXYPN && !grassYZNP) {
                renderer.field_78627_G = renderer.field_78631_L;
                renderer.field_78709_ae = renderer.field_78692_aj;
            } else {
                renderer.field_78627_G = block.func_71888_h(renderer.field_78669_a, x + 1, y + 1, z);
                renderer.field_78709_ae = block.func_71874_e(renderer.field_78669_a, x + 1, y + 1, z);
            }
            if (renderer.field_83025_k <= 0.0) {
                ++z;
            }
            mixedBrightnessForSide = mixedBrightnessForBlock;
            if (renderer.field_83025_k <= 0.0 || !renderer.field_78669_a.func_72804_r(x, y, z - 1)) {
                mixedBrightnessForSide = block.func_71874_e(renderer.field_78669_a, x, y, z - 1);
            }
            lightValue = block.func_71888_h(renderer.field_78669_a, x, y, z - 1);
            colorModTopLeft = (renderer.field_78637_K + renderer.field_78630_C + lightValue + renderer.field_78626_F) / 4.0f;
            colorModBottomLeft = (lightValue + renderer.field_78626_F + renderer.field_78631_L + renderer.field_78627_G) / 4.0f;
            colorModBottomRight = (renderer.field_78712_x + lightValue + renderer.field_78708_z + renderer.field_78631_L) / 4.0f;
            colorModTopRight = (renderer.field_78691_u + renderer.field_78637_K + renderer.field_78712_x + lightValue) / 4.0f;
            renderer.field_78700_an = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78690_ai, renderer.field_78704_aa, renderer.field_78703_ad, mixedBrightnessForSide);
            renderer.field_78694_ao = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78703_ad, renderer.field_78692_aj, renderer.field_78709_ae, mixedBrightnessForSide);
            renderer.field_78696_ap = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78645_V, renderer.field_78657_X, renderer.field_78692_aj, mixedBrightnessForSide);
            int n = renderer.field_78676_aq = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78649_S, renderer.field_78690_ai, renderer.field_78645_V, mixedBrightnessForSide);
            if (locationColorFlag) {
                renderer.field_78670_at = renderer.field_78684_au = r * 0.8f;
                renderer.field_78672_as = renderer.field_78684_au;
                renderer.field_78674_ar = renderer.field_78684_au;
                renderer.field_78678_ax = renderer.field_78665_ay = g * 0.8f;
                renderer.field_78680_aw = renderer.field_78665_ay;
                renderer.field_78682_av = renderer.field_78665_ay;
                renderer.field_78651_aB = renderer.field_78652_aC = b * 0.8f;
                renderer.field_78650_aA = renderer.field_78652_aC;
                renderer.field_78663_az = renderer.field_78652_aC;
            } else {
                renderer.field_78684_au = 0.8f;
                renderer.field_78670_at = 0.8f;
                renderer.field_78672_as = 0.8f;
                renderer.field_78674_ar = 0.8f;
                renderer.field_78665_ay = 0.8f;
                renderer.field_78678_ax = 0.8f;
                renderer.field_78680_aw = 0.8f;
                renderer.field_78682_av = 0.8f;
                renderer.field_78652_aC = 0.8f;
                renderer.field_78651_aB = 0.8f;
                renderer.field_78650_aA = 0.8f;
                renderer.field_78663_az = 0.8f;
            }
            renderer.field_78674_ar *= colorModTopLeft;
            renderer.field_78682_av *= colorModTopLeft;
            renderer.field_78663_az *= colorModTopLeft;
            renderer.field_78672_as *= colorModBottomLeft;
            renderer.field_78680_aw *= colorModBottomLeft;
            renderer.field_78650_aA *= colorModBottomLeft;
            renderer.field_78670_at *= colorModBottomRight;
            renderer.field_78678_ax *= colorModBottomRight;
            renderer.field_78651_aB *= colorModBottomRight;
            renderer.field_78684_au *= colorModTopRight;
            renderer.field_78665_ay *= colorModTopRight;
            renderer.field_78652_aC *= colorModTopRight;
            renderer.func_78611_c(block, (double)x, (double)y, (double)z, icon);
            renderedFace = true;
        }
        if (face == ForgeDirection.SOUTH && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x, y, z + 1, 3))) {
            if (renderer.field_83022_l >= 1.0) {
                ++z;
            }
            renderer.field_78632_M = block.func_71888_h(renderer.field_78669_a, x - 1, y, z);
            renderer.field_78633_N = block.func_71888_h(renderer.field_78669_a, x + 1, y, z);
            renderer.field_78710_y = block.func_71888_h(renderer.field_78669_a, x, y - 1, z);
            renderer.field_78635_I = block.func_71888_h(renderer.field_78669_a, x, y + 1, z);
            renderer.field_78686_ak = block.func_71874_e(renderer.field_78669_a, x - 1, y, z);
            renderer.field_78688_al = block.func_71874_e(renderer.field_78669_a, x + 1, y, z);
            renderer.field_78643_W = block.func_71874_e(renderer.field_78669_a, x, y - 1, z);
            renderer.field_78706_ag = block.func_71874_e(renderer.field_78669_a, x, y + 1, z);
            grassXYPN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x + 1, y, z + 1)];
            grassXYNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x - 1, y, z + 1)];
            grassYZNP = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x, y + 1, z + 1)];
            grassYZNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x, y - 1, z + 1)];
            if (!grassXYNN && !grassYZNN) {
                renderer.field_78687_w = renderer.field_78632_M;
                renderer.field_78639_U = renderer.field_78686_ak;
            } else {
                renderer.field_78687_w = block.func_71888_h(renderer.field_78669_a, x - 1, y - 1, z);
                renderer.field_78639_U = block.func_71874_e(renderer.field_78669_a, x - 1, y - 1, z);
            }
            if (!grassXYNN && !grassYZNP) {
                renderer.field_78625_E = renderer.field_78632_M;
                renderer.field_78702_ac = renderer.field_78686_ak;
            } else {
                renderer.field_78625_E = block.func_71888_h(renderer.field_78669_a, x - 1, y + 1, z);
                renderer.field_78702_ac = block.func_71874_e(renderer.field_78669_a, x - 1, y + 1, z);
            }
            if (!grassXYPN && !grassYZNN) {
                renderer.field_78629_B = renderer.field_78633_N;
                renderer.field_78660_Z = renderer.field_78688_al;
            } else {
                renderer.field_78629_B = block.func_71888_h(renderer.field_78669_a, x + 1, y - 1, z);
                renderer.field_78660_Z = block.func_71874_e(renderer.field_78669_a, x + 1, y - 1, z);
            }
            if (!grassXYPN && !grassYZNP) {
                renderer.field_78636_J = renderer.field_78633_N;
                renderer.field_78707_ah = renderer.field_78688_al;
            } else {
                renderer.field_78636_J = block.func_71888_h(renderer.field_78669_a, x + 1, y + 1, z);
                renderer.field_78707_ah = block.func_71874_e(renderer.field_78669_a, x + 1, y + 1, z);
            }
            if (renderer.field_83022_l >= 1.0) {
                --z;
            }
            mixedBrightnessForSide = mixedBrightnessForBlock;
            if (renderer.field_83022_l >= 1.0 || !renderer.field_78669_a.func_72804_r(x, y, z + 1)) {
                mixedBrightnessForSide = block.func_71874_e(renderer.field_78669_a, x, y, z + 1);
            }
            lightValue = block.func_71888_h(renderer.field_78669_a, x, y, z + 1);
            colorModTopLeft = (renderer.field_78632_M + renderer.field_78625_E + lightValue + renderer.field_78635_I) / 4.0f;
            colorModTopRight = (lightValue + renderer.field_78635_I + renderer.field_78633_N + renderer.field_78636_J) / 4.0f;
            colorModBottomRight = (renderer.field_78710_y + lightValue + renderer.field_78629_B + renderer.field_78633_N) / 4.0f;
            colorModBottomLeft = (renderer.field_78687_w + renderer.field_78632_M + renderer.field_78710_y + lightValue) / 4.0f;
            renderer.field_78700_an = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78686_ak, renderer.field_78702_ac, renderer.field_78706_ag, mixedBrightnessForSide);
            renderer.field_78676_aq = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78706_ag, renderer.field_78688_al, renderer.field_78707_ah, mixedBrightnessForSide);
            renderer.field_78696_ap = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78643_W, renderer.field_78660_Z, renderer.field_78688_al, mixedBrightnessForSide);
            int n = renderer.field_78694_ao = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78639_U, renderer.field_78686_ak, renderer.field_78643_W, mixedBrightnessForSide);
            if (locationColorFlag) {
                renderer.field_78670_at = renderer.field_78684_au = r * 0.8f;
                renderer.field_78672_as = renderer.field_78684_au;
                renderer.field_78674_ar = renderer.field_78684_au;
                renderer.field_78678_ax = renderer.field_78665_ay = g * 0.8f;
                renderer.field_78680_aw = renderer.field_78665_ay;
                renderer.field_78682_av = renderer.field_78665_ay;
                renderer.field_78651_aB = renderer.field_78652_aC = b * 0.8f;
                renderer.field_78650_aA = renderer.field_78652_aC;
                renderer.field_78663_az = renderer.field_78652_aC;
            } else {
                renderer.field_78684_au = 0.8f;
                renderer.field_78670_at = 0.8f;
                renderer.field_78672_as = 0.8f;
                renderer.field_78674_ar = 0.8f;
                renderer.field_78665_ay = 0.8f;
                renderer.field_78678_ax = 0.8f;
                renderer.field_78680_aw = 0.8f;
                renderer.field_78682_av = 0.8f;
                renderer.field_78652_aC = 0.8f;
                renderer.field_78651_aB = 0.8f;
                renderer.field_78650_aA = 0.8f;
                renderer.field_78663_az = 0.8f;
            }
            renderer.field_78674_ar *= colorModTopLeft;
            renderer.field_78682_av *= colorModTopLeft;
            renderer.field_78663_az *= colorModTopLeft;
            renderer.field_78672_as *= colorModBottomLeft;
            renderer.field_78680_aw *= colorModBottomLeft;
            renderer.field_78650_aA *= colorModBottomLeft;
            renderer.field_78670_at *= colorModBottomRight;
            renderer.field_78678_ax *= colorModBottomRight;
            renderer.field_78651_aB *= colorModBottomRight;
            renderer.field_78684_au *= colorModTopRight;
            renderer.field_78665_ay *= colorModTopRight;
            renderer.field_78652_aC *= colorModTopRight;
            renderer.func_78622_d(block, (double)x, (double)y, (double)z, icon);
            renderedFace = true;
        }
        if (face == ForgeDirection.WEST && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x - 1, y, z, 4))) {
            if (renderer.field_83021_g <= 0.0) {
                --x;
            }
            renderer.field_78689_v = block.func_71888_h(renderer.field_78669_a, x, y - 1, z);
            renderer.field_78637_K = block.func_71888_h(renderer.field_78669_a, x, y, z - 1);
            renderer.field_78632_M = block.func_71888_h(renderer.field_78669_a, x, y, z + 1);
            renderer.field_78624_D = block.func_71888_h(renderer.field_78669_a, x, y + 1, z);
            renderer.field_78641_T = block.func_71874_e(renderer.field_78669_a, x, y - 1, z);
            renderer.field_78690_ai = block.func_71874_e(renderer.field_78669_a, x, y, z - 1);
            renderer.field_78686_ak = block.func_71874_e(renderer.field_78669_a, x, y, z + 1);
            renderer.field_78705_ab = block.func_71874_e(renderer.field_78669_a, x, y + 1, z);
            grassXYPN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x - 1, y + 1, z)];
            grassXYNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x - 1, y - 1, z)];
            grassYZNP = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x - 1, y, z - 1)];
            grassYZNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x - 1, y, z + 1)];
            if (!grassYZNP && !grassXYNN) {
                renderer.field_78691_u = renderer.field_78637_K;
                renderer.field_78649_S = renderer.field_78690_ai;
            } else {
                renderer.field_78691_u = block.func_71888_h(renderer.field_78669_a, x, y - 1, z - 1);
                renderer.field_78649_S = block.func_71874_e(renderer.field_78669_a, x, y - 1, z - 1);
            }
            if (!grassYZNN && !grassXYNN) {
                renderer.field_78687_w = renderer.field_78632_M;
                renderer.field_78639_U = renderer.field_78686_ak;
            } else {
                renderer.field_78687_w = block.func_71888_h(renderer.field_78669_a, x, y - 1, z + 1);
                renderer.field_78639_U = block.func_71874_e(renderer.field_78669_a, x, y - 1, z + 1);
            }
            if (!grassYZNP && !grassXYPN) {
                renderer.field_78630_C = renderer.field_78637_K;
                renderer.field_78704_aa = renderer.field_78690_ai;
            } else {
                renderer.field_78630_C = block.func_71888_h(renderer.field_78669_a, x, y + 1, z - 1);
                renderer.field_78704_aa = block.func_71874_e(renderer.field_78669_a, x, y + 1, z - 1);
            }
            if (!grassYZNN && !grassXYPN) {
                renderer.field_78625_E = renderer.field_78632_M;
                renderer.field_78702_ac = renderer.field_78686_ak;
            } else {
                renderer.field_78625_E = block.func_71888_h(renderer.field_78669_a, x, y + 1, z + 1);
                renderer.field_78702_ac = block.func_71874_e(renderer.field_78669_a, x, y + 1, z + 1);
            }
            if (renderer.field_83021_g <= 0.0) {
                ++x;
            }
            mixedBrightnessForSide = mixedBrightnessForBlock;
            if (renderer.field_83021_g <= 0.0 || !renderer.field_78669_a.func_72804_r(x - 1, y, z)) {
                mixedBrightnessForSide = block.func_71874_e(renderer.field_78669_a, x - 1, y, z);
            }
            lightValue = block.func_71888_h(renderer.field_78669_a, x - 1, y, z);
            colorModTopRight = (renderer.field_78689_v + renderer.field_78687_w + lightValue + renderer.field_78632_M) / 4.0f;
            colorModTopLeft = (lightValue + renderer.field_78632_M + renderer.field_78624_D + renderer.field_78625_E) / 4.0f;
            colorModBottomLeft = (renderer.field_78637_K + lightValue + renderer.field_78630_C + renderer.field_78624_D) / 4.0f;
            colorModBottomRight = (renderer.field_78691_u + renderer.field_78689_v + renderer.field_78637_K + lightValue) / 4.0f;
            renderer.field_78676_aq = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78641_T, renderer.field_78639_U, renderer.field_78686_ak, mixedBrightnessForSide);
            renderer.field_78700_an = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78686_ak, renderer.field_78705_ab, renderer.field_78702_ac, mixedBrightnessForSide);
            renderer.field_78694_ao = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78690_ai, renderer.field_78704_aa, renderer.field_78705_ab, mixedBrightnessForSide);
            int n = renderer.field_78696_ap = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78649_S, renderer.field_78641_T, renderer.field_78690_ai, mixedBrightnessForSide);
            if (locationColorFlag) {
                renderer.field_78670_at = renderer.field_78684_au = r * 0.6f;
                renderer.field_78672_as = renderer.field_78684_au;
                renderer.field_78674_ar = renderer.field_78684_au;
                renderer.field_78678_ax = renderer.field_78665_ay = g * 0.6f;
                renderer.field_78680_aw = renderer.field_78665_ay;
                renderer.field_78682_av = renderer.field_78665_ay;
                renderer.field_78651_aB = renderer.field_78652_aC = b * 0.6f;
                renderer.field_78650_aA = renderer.field_78652_aC;
                renderer.field_78663_az = renderer.field_78652_aC;
            } else {
                renderer.field_78684_au = 0.6f;
                renderer.field_78670_at = 0.6f;
                renderer.field_78672_as = 0.6f;
                renderer.field_78674_ar = 0.6f;
                renderer.field_78665_ay = 0.6f;
                renderer.field_78678_ax = 0.6f;
                renderer.field_78680_aw = 0.6f;
                renderer.field_78682_av = 0.6f;
                renderer.field_78652_aC = 0.6f;
                renderer.field_78651_aB = 0.6f;
                renderer.field_78650_aA = 0.6f;
                renderer.field_78663_az = 0.6f;
            }
            renderer.field_78674_ar *= colorModTopLeft;
            renderer.field_78682_av *= colorModTopLeft;
            renderer.field_78663_az *= colorModTopLeft;
            renderer.field_78672_as *= colorModBottomLeft;
            renderer.field_78680_aw *= colorModBottomLeft;
            renderer.field_78650_aA *= colorModBottomLeft;
            renderer.field_78670_at *= colorModBottomRight;
            renderer.field_78678_ax *= colorModBottomRight;
            renderer.field_78651_aB *= colorModBottomRight;
            renderer.field_78684_au *= colorModTopRight;
            renderer.field_78665_ay *= colorModTopRight;
            renderer.field_78652_aC *= colorModTopRight;
            renderer.func_78573_e(block, (double)x, (double)y, (double)z, icon);
            renderedFace = true;
        }
        if (face == ForgeDirection.EAST && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x + 1, y, z, 5))) {
            if (renderer.field_83026_h >= 1.0) {
                ++x;
            }
            renderer.field_78628_A = block.func_71888_h(renderer.field_78669_a, x, y - 1, z);
            renderer.field_78631_L = block.func_71888_h(renderer.field_78669_a, x, y, z - 1);
            renderer.field_78633_N = block.func_71888_h(renderer.field_78669_a, x, y, z + 1);
            renderer.field_78634_H = block.func_71888_h(renderer.field_78669_a, x, y + 1, z);
            renderer.field_78655_Y = block.func_71874_e(renderer.field_78669_a, x, y - 1, z);
            renderer.field_78692_aj = block.func_71874_e(renderer.field_78669_a, x, y, z - 1);
            renderer.field_78688_al = block.func_71874_e(renderer.field_78669_a, x, y, z + 1);
            renderer.field_78711_af = block.func_71874_e(renderer.field_78669_a, x, y + 1, z);
            grassXYPN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x + 1, y + 1, z)];
            grassXYNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x + 1, y - 1, z)];
            grassYZNP = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x + 1, y, z + 1)];
            grassYZNN = Block.field_71985_p[renderer.field_78669_a.func_72798_a(x + 1, y, z - 1)];
            if (!grassXYNN && !grassYZNN) {
                renderer.field_78708_z = renderer.field_78631_L;
                renderer.field_78657_X = renderer.field_78692_aj;
            } else {
                renderer.field_78708_z = block.func_71888_h(renderer.field_78669_a, x, y - 1, z - 1);
                renderer.field_78657_X = block.func_71874_e(renderer.field_78669_a, x, y - 1, z - 1);
            }
            if (!grassXYNN && !grassYZNP) {
                renderer.field_78629_B = renderer.field_78633_N;
                renderer.field_78660_Z = renderer.field_78688_al;
            } else {
                renderer.field_78629_B = block.func_71888_h(renderer.field_78669_a, x, y - 1, z + 1);
                renderer.field_78660_Z = block.func_71874_e(renderer.field_78669_a, x, y - 1, z + 1);
            }
            if (!grassXYPN && !grassYZNN) {
                renderer.field_78627_G = renderer.field_78631_L;
                renderer.field_78709_ae = renderer.field_78692_aj;
            } else {
                renderer.field_78627_G = block.func_71888_h(renderer.field_78669_a, x, y + 1, z - 1);
                renderer.field_78709_ae = block.func_71874_e(renderer.field_78669_a, x, y + 1, z - 1);
            }
            if (!grassXYPN && !grassYZNP) {
                renderer.field_78636_J = renderer.field_78633_N;
                renderer.field_78707_ah = renderer.field_78688_al;
            } else {
                renderer.field_78636_J = block.func_71888_h(renderer.field_78669_a, x, y + 1, z + 1);
                renderer.field_78707_ah = block.func_71874_e(renderer.field_78669_a, x, y + 1, z + 1);
            }
            if (renderer.field_83026_h >= 1.0) {
                --x;
            }
            mixedBrightnessForSide = mixedBrightnessForBlock;
            if (renderer.field_83026_h >= 1.0 || !renderer.field_78669_a.func_72804_r(x + 1, y, z)) {
                mixedBrightnessForSide = block.func_71874_e(renderer.field_78669_a, x + 1, y, z);
            }
            lightValue = block.func_71888_h(renderer.field_78669_a, x + 1, y, z);
            colorModTopLeft = (renderer.field_78628_A + renderer.field_78629_B + lightValue + renderer.field_78633_N) / 4.0f;
            colorModBottomLeft = (renderer.field_78708_z + renderer.field_78628_A + renderer.field_78631_L + lightValue) / 4.0f;
            colorModBottomRight = (renderer.field_78631_L + lightValue + renderer.field_78627_G + renderer.field_78634_H) / 4.0f;
            colorModTopRight = (lightValue + renderer.field_78633_N + renderer.field_78634_H + renderer.field_78636_J) / 4.0f;
            renderer.field_78700_an = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78655_Y, renderer.field_78660_Z, renderer.field_78688_al, mixedBrightnessForSide);
            renderer.field_78676_aq = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78688_al, renderer.field_78711_af, renderer.field_78707_ah, mixedBrightnessForSide);
            renderer.field_78696_ap = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78692_aj, renderer.field_78709_ae, renderer.field_78711_af, mixedBrightnessForSide);
            int n = renderer.field_78694_ao = brightFlag ? brightness : renderer.func_78602_a(renderer.field_78657_X, renderer.field_78655_Y, renderer.field_78692_aj, mixedBrightnessForSide);
            if (locationColorFlag) {
                renderer.field_78670_at = renderer.field_78684_au = r * 0.6f;
                renderer.field_78672_as = renderer.field_78684_au;
                renderer.field_78674_ar = renderer.field_78684_au;
                renderer.field_78678_ax = renderer.field_78665_ay = g * 0.6f;
                renderer.field_78680_aw = renderer.field_78665_ay;
                renderer.field_78682_av = renderer.field_78665_ay;
                renderer.field_78651_aB = renderer.field_78652_aC = b * 0.6f;
                renderer.field_78650_aA = renderer.field_78652_aC;
                renderer.field_78663_az = renderer.field_78652_aC;
            } else {
                renderer.field_78684_au = 0.6f;
                renderer.field_78670_at = 0.6f;
                renderer.field_78672_as = 0.6f;
                renderer.field_78674_ar = 0.6f;
                renderer.field_78665_ay = 0.6f;
                renderer.field_78678_ax = 0.6f;
                renderer.field_78680_aw = 0.6f;
                renderer.field_78682_av = 0.6f;
                renderer.field_78652_aC = 0.6f;
                renderer.field_78651_aB = 0.6f;
                renderer.field_78650_aA = 0.6f;
                renderer.field_78663_az = 0.6f;
            }
            renderer.field_78674_ar *= colorModTopLeft;
            renderer.field_78682_av *= colorModTopLeft;
            renderer.field_78663_az *= colorModTopLeft;
            renderer.field_78672_as *= colorModBottomLeft;
            renderer.field_78680_aw *= colorModBottomLeft;
            renderer.field_78650_aA *= colorModBottomLeft;
            renderer.field_78670_at *= colorModBottomRight;
            renderer.field_78678_ax *= colorModBottomRight;
            renderer.field_78651_aB *= colorModBottomRight;
            renderer.field_78684_au *= colorModTopRight;
            renderer.field_78665_ay *= colorModTopRight;
            renderer.field_78652_aC *= colorModTopRight;
            renderer.func_78605_f(block, (double)x, (double)y, (double)z, icon);
            renderedFace = true;
        }
        renderer.field_78677_m = false;
        return renderedFace;
    }

    private static boolean renderFaceWithColorMultiplier(RenderBlocks renderer, Block block, IBlockAccess world, Icon icon, int x, int y, int z, float r, float g, float b, int brightness, ForgeDirection face) {
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean flag = false;
        float yMod = 0.5f;
        float f4 = 1.0f;
        float zMod = 0.8f;
        float xMod = 0.6f;
        float f7 = f4 * r;
        float f8 = f4 * g;
        float f9 = f4 * b;
        float rY = yMod;
        float rZ = zMod;
        float rX = xMod;
        float gY = yMod;
        float gZ = zMod;
        float gX = xMod;
        float bY = yMod;
        float bZ = zMod;
        float bX = xMod;
        if (block != Block.field_71980_u) {
            rY = yMod * r;
            rZ = zMod * r;
            rX = xMod * r;
            gY = yMod * g;
            gZ = zMod * g;
            gX = xMod * g;
            bY = yMod * b;
            bZ = zMod * b;
            bX = xMod * b;
        }
        int l = block.func_71874_e(renderer.field_78669_a, x, y, z);
        if (face == ForgeDirection.DOWN && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x, y - 1, z, 0))) {
            if (brightness != -1) {
                tessellator.func_78380_c(brightness);
            } else {
                tessellator.func_78380_c(renderer.field_83027_i > 0.0 ? l : block.func_71874_e(renderer.field_78669_a, x, y - 1, z));
            }
            tessellator.func_78386_a(rY, gY, bY);
            renderer.func_78613_a(block, (double)x, (double)y, (double)z, icon);
            flag = true;
        }
        if (face == ForgeDirection.UP && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x, y + 1, z, 1))) {
            if (brightness != -1) {
                tessellator.func_78380_c(brightness);
            } else {
                tessellator.func_78380_c(renderer.field_83024_j < 1.0 ? l : block.func_71874_e(renderer.field_78669_a, x, y + 1, z));
            }
            tessellator.func_78386_a(f7, f8, f9);
            renderer.func_78617_b(block, (double)x, (double)y, (double)z, icon);
            flag = true;
        }
        if (face == ForgeDirection.NORTH && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x, y, z - 1, 2))) {
            if (brightness != -1) {
                tessellator.func_78380_c(brightness);
            } else {
                tessellator.func_78380_c(renderer.field_83025_k > 0.0 ? l : block.func_71874_e(renderer.field_78669_a, x, y, z - 1));
            }
            tessellator.func_78386_a(rZ, gZ, bZ);
            renderer.func_78611_c(block, (double)x, (double)y, (double)z, icon);
            flag = true;
        }
        if (face == ForgeDirection.SOUTH && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x, y, z + 1, 3))) {
            if (brightness != -1) {
                tessellator.func_78380_c(brightness);
            } else {
                tessellator.func_78380_c(renderer.field_83022_l < 1.0 ? l : block.func_71874_e(renderer.field_78669_a, x, y, z + 1));
            }
            tessellator.func_78386_a(rZ, gZ, bZ);
            renderer.func_78622_d(block, (double)x, (double)y, (double)z, icon);
            flag = true;
        }
        if (face == ForgeDirection.WEST && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x - 1, y, z, 40))) {
            if (brightness != -1) {
                tessellator.func_78380_c(brightness);
            } else {
                tessellator.func_78380_c(renderer.field_83021_g > 0.0 ? l : block.func_71874_e(renderer.field_78669_a, x - 1, y, z));
            }
            tessellator.func_78386_a(rX, gX, bX);
            renderer.func_78573_e(block, (double)x, (double)y, (double)z, icon);
            flag = true;
        }
        if (face == ForgeDirection.EAST && (renderer.field_78661_f || block.func_71877_c(renderer.field_78669_a, x + 1, y, z, 5))) {
            if (brightness != -1) {
                tessellator.func_78380_c(brightness);
            } else {
                tessellator.func_78380_c(renderer.field_83026_h < 1.0 ? l : block.func_71874_e(renderer.field_78669_a, x + 1, y, z));
            }
            tessellator.func_78386_a(rX, gX, bX);
            renderer.func_78605_f(block, (double)x, (double)y, (double)z, icon);
            flag = true;
        }
        return flag;
    }
}

