/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.integration;

import biomesoplenty.api.Biomes;
import biomesoplenty.api.BlockReferences;
import biomesoplenty.api.Blocks;
import biomesoplenty.api.Items;
import biomesoplenty.integration.minefactoryreloaded.Fertilizable;
import biomesoplenty.integration.minefactoryreloaded.FruitLeaves;
import biomesoplenty.integration.minefactoryreloaded.Harvestable;
import biomesoplenty.integration.minefactoryreloaded.Plantable;
import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;

public class MFRIntegration {
    protected static void init() {
        MFRIntegration.registerRubberTreeBiomes();
        MFRIntegration.registerFarmables();
        MFRIntegration.registerSludgeDrops();
    }

    private static void registerRubberTreeBiomes() {
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.bayou.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.birchForest.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.bog.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.borealForest.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.deciduousForest.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.forestNew.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.grove.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.jungleNew.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.lushSwamp.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.mapleWoods.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.rainforest.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.seasonalForest.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.shield.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.swamplandNew.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.temperateRainforest.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.thicket.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.tropicalRainforest.get()).field_76791_y);
        FactoryRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.woodland.get()).field_76791_y);
    }

    private static void registerFarmables() {
        Optional[] bopLeaves = new Optional[]{Blocks.leaves1, Blocks.leaves2, Blocks.leaves3, Blocks.leaves4, Blocks.leavesColorized1, Blocks.leavesColorized2, Blocks.treeMoss, Blocks.willow, Blocks.ivy, Blocks.moss};
        Optional[] bopFruitLeaves = new Optional[]{Blocks.leavesFruit, Blocks.leavesFruit2};
        Optional[] bopLogs = new Optional[]{Blocks.logs1, Blocks.logs2, Blocks.logs3, Blocks.logs4, Blocks.bamboo};
        Optional[] bopMiscStandardHarvestables = new Optional[]{Blocks.flowers, Blocks.plants, Blocks.foliage, Blocks.mushrooms};
        Optional[] bopSaplings = new Optional[]{Blocks.saplings, Blocks.colorizedSaplings};
        for (Optional leaves : bopLeaves) {
            FactoryRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable(((Block)leaves.get()).field_71990_ca, HarvestType.TreeLeaf));
        }
        for (Optional log : bopLogs) {
            FactoryRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable(((Block)log.get()).field_71990_ca, HarvestType.Tree));
        }
        for (Optional harvestable : bopMiscStandardHarvestables) {
            FactoryRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable(((Block)harvestable.get()).field_71990_ca, HarvestType.Normal));
        }
        for (Optional sapling : bopSaplings) {
            FactoryRegistry.registerFertilizable((IFactoryFertilizable)new Fertilizable(((Block)sapling.get()).field_71990_ca));
            FactoryRegistry.registerPlantable((IFactoryPlantable)new Plantable(((Block)sapling.get()).field_71990_ca));
        }
        for (Optional leaves : bopFruitLeaves) {
            FactoryRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable(((Block)leaves.get()).field_71990_ca, HarvestType.TreeLeaf));
            FactoryRegistry.registerFruit((IFactoryFruit)new FruitLeaves(((Block)leaves.get()).field_71990_ca));
        }
    }

    private static void registerSludgeDrops() {
        FactoryRegistry.registerSludgeDrop((int)15, (ItemStack)BlockReferences.getBlockItemStack("driedDirt"));
        FactoryRegistry.registerSludgeDrop((int)15, (ItemStack)BlockReferences.getBlockItemStack("hardSand"));
        FactoryRegistry.registerSludgeDrop((int)15, (ItemStack)BlockReferences.getBlockItemStack("hardDirt"));
        FactoryRegistry.registerSludgeDrop((int)15, (ItemStack)new ItemStack((Item)Items.miscItems.get(), 4, 1));
        FactoryRegistry.registerSludgeDrop((int)25, (ItemStack)new ItemStack((Item)Items.mudball.get(), 4));
    }
}

