/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.world.layer;

import biomesoplenty.world.layer.BiomeLayerBiomes;
import biomesoplenty.world.layer.BiomeLayerCreate;
import biomesoplenty.world.layer.BiomeLayerFuzzyZoom;
import biomesoplenty.world.layer.BiomeLayerIsland;
import biomesoplenty.world.layer.BiomeLayerRiver;
import biomesoplenty.world.layer.BiomeLayerRiverInit;
import biomesoplenty.world.layer.BiomeLayerRiverMix;
import biomesoplenty.world.layer.BiomeLayerShore;
import biomesoplenty.world.layer.BiomeLayerSmooth;
import biomesoplenty.world.layer.BiomeLayerSub;
import biomesoplenty.world.layer.BiomeLayerVoronoiZoom;
import biomesoplenty.world.layer.BiomeLayerZoom;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public abstract class BiomeLayer
extends GenLayer {
    public static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType worldtype, int dim) {
        if (dim == 0) {
            BiomeLayer obj = new BiomeLayerCreate(1L, true);
            obj = new BiomeLayerFuzzyZoom(2000L, obj);
            obj = new BiomeLayerIsland(1L, obj);
            obj = new BiomeLayerZoom(2001L, obj);
            obj = new BiomeLayerIsland(2L, obj);
            obj = new BiomeLayerZoom(2002L, obj);
            obj = new BiomeLayerIsland(3L, obj);
            obj = new BiomeLayerZoom(2003L, obj);
            obj = new BiomeLayerIsland(4L, obj);
            int size = 4;
            size = BiomeLayer.getModdedBiomeSize(worldtype, (byte)size);
            BiomeLayer obj1 = obj;
            obj1 = BiomeLayerZoom.func_75915_a(1000L, obj1, 0);
            obj1 = new BiomeLayerRiverInit(100L, obj1);
            obj1 = BiomeLayerZoom.func_75915_a(1000L, obj1, size + 2);
            obj1 = new BiomeLayerRiver(1L, obj1);
            obj1 = new BiomeLayerSmooth(1000L, obj1);
            BiomeLayer obj2 = obj;
            obj2 = BiomeLayerZoom.func_75915_a(1000L, obj2, 0);
            obj2 = new BiomeLayerBiomes(200L, obj2, worldtype, 0);
            obj2 = BiomeLayerZoom.func_75915_a(1000L, obj2, 2);
            obj2 = new BiomeLayerSub(1000L, obj2);
            obj2 = new BiomeLayerZoom(1000L, obj2);
            obj2 = new BiomeLayerShore(1000L, obj2);
            for (int i = 1; i < size; ++i) {
                obj2 = new BiomeLayerZoom(1000 + i, obj2);
            }
            obj2 = new BiomeLayerSmooth(1000L, obj2);
            obj2 = new BiomeLayerRiverMix(100L, obj2, obj1);
            BiomeLayerRiverMix bwg4layerrivermix = (BiomeLayerRiverMix)obj2;
            BiomeLayerVoronoiZoom genlayervoronoizoom = new BiomeLayerVoronoiZoom(10L, obj2);
            obj2.func_75905_a(seed);
            genlayervoronoizoom.func_75905_a(seed);
            return new GenLayer[]{obj2, genlayervoronoizoom, bwg4layerrivermix};
        }
        int biomesize = 3;
        if (dim == 1) {
            biomesize = 2;
        }
        BiomeLayer obj = new BiomeLayerCreate(1L, false);
        obj = new BiomeLayerFuzzyZoom(2000L, obj);
        for (int i = 1; i < 3; ++i) {
            obj = new BiomeLayerZoom(2000L + (long)i, obj);
        }
        obj = BiomeLayerZoom.func_75915_a(1000L, obj, 0);
        obj = new BiomeLayerBiomes(200L, obj, worldtype, dim);
        obj = BiomeLayerZoom.func_75915_a(1000L, obj, 2);
        for (int j = 0; j < biomesize; ++j) {
            obj = new BiomeLayerZoom(1000L + (long)j, obj);
        }
        BiomeLayerVoronoiZoom genlayervoronoizoom = new BiomeLayerVoronoiZoom(10L, obj);
        obj.func_75905_a(seed);
        genlayervoronoizoom.func_75905_a(seed);
        return new GenLayer[]{obj, genlayervoronoizoom};
    }

    public BiomeLayer(long seed) {
        super(seed);
    }

    public static byte getModdedBiomeSize(WorldType worldType, byte original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.newSize;
    }
}

