/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.items.ItemCamera;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="camera", value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation VIEWFINDER = new ResourceLocation("camera", "textures/gui/viewfinder_overlay.png");
    private static final ResourceLocation ZOOM = new ResourceLocation("camera", "textures/gui/zoom.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private boolean inCameraMode;
    private ResourceLocation currentShader;

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.inCameraMode = this.isInCameraMode();
        if (!this.inCameraMode) {
            this.setShader(null);
            return;
        }
        event.setCanceled(true);
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        this.mc.field_71474_y.field_74320_O = 0;
        this.setShader(this.getShader((EntityPlayer)this.mc.field_71439_g));
        this.drawViewFinder();
        this.drawZoom(1.0f);
    }

    private void drawViewFinder() {
        float hnew;
        float wnew;
        GlStateManager.func_179094_E();
        this.mc.func_110434_K().func_110577_a(VIEWFINDER);
        float imageWidth = 192.0f;
        float imageHeight = 100.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float ws = this.mc.field_195558_d.func_198107_o();
        float hs = this.mc.field_195558_d.func_198087_p();
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + hnew), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + wnew), (double)(top + hnew), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + wnew), (double)top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void drawZoom(float percent) {
        GlStateManager.func_179094_E();
        this.mc.func_110434_K().func_110577_a(ZOOM);
        int zoomWidth = 112;
        int zoomHeight = 20;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int width = this.mc.field_195558_d.func_198107_o();
        int height = this.mc.field_195558_d.func_198087_p();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int left = (width - zoomWidth) / 2;
        int top = height / 40;
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + zoomHeight / 2), 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)(left + zoomWidth), (double)(top + zoomHeight / 2), 0.0).func_187315_a(1.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)(left + zoomWidth), (double)top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        int percWidth = (int)(Math.max(Math.min(percent, 1.0f), 0.0f) * (float)zoomWidth);
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + zoomHeight / 2), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + percWidth), (double)(top + zoomHeight / 2), 0.0).func_187315_a(1.0 * (double)percent, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + percWidth), (double)top, 0.0).func_187315_a(1.0 * (double)percent, 0.5).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (this.inCameraMode) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (this.inCameraMode && event.getGui() instanceof GuiIngameMenu) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDisableCameraMode());
            event.setCanceled(true);
        }
    }

    private ResourceLocation getShader(EntityPlayer player) {
        ItemStack stack = this.mc.field_71439_g.func_184614_ca();
        if (!stack.func_77973_b().equals((Object)Main.CAMERA)) {
            return null;
        }
        return Shaders.getShader(Main.CAMERA.getShader(stack));
    }

    private void setShader(ResourceLocation shader) {
        if (shader == null) {
            this.mc.field_71460_t.func_181022_b();
        } else if (!shader.equals((Object)this.currentShader)) {
            try {
                this.mc.field_71460_t.func_175069_a(shader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentShader = shader;
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == this.mc.field_71439_g) {
            return;
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof ItemCamera) || !Main.CAMERA.isActive(stack)) continue;
            player.func_184598_c(hand);
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == this.mc.field_71439_g) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        event.getEntityPlayer().func_184602_cy();
    }

    private ItemStack getActiveCamera() {
        if (this.mc.field_71439_g == null) {
            return null;
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = this.mc.field_71439_g.func_184586_b(hand);
            if (!stack.func_77973_b().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(stack)) continue;
            return stack;
        }
        return null;
    }

    private boolean isInCameraMode() {
        return this.getActiveCamera() != null;
    }
}

