/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import java.text.SimpleDateFormat;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static SimpleDateFormat imageDateFormat;
    public static long imageCooldown;

    public static void loadServer() {
        imageDateFormat = new SimpleDateFormat((String)Config.SERVER.imageDateFormat.get());
        imageCooldown = (Long)Config.SERVER.imageCooldown.get();
    }

    static {
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
        imageDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        imageCooldown = 5000L;
    }

    public static class ServerConfig {
        public ForgeConfigSpec.LongValue imageCooldown;
        public ForgeConfigSpec.ConfigValue<String> imageDateFormat;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            this.imageCooldown = builder.comment("The time in milliseconds the CAMERA will be on cooldown after taking an IMAGE").translation("image_cooldown").defineInRange("image_cooldown", 5000L, 100L, Integer.MAX_VALUE);
            this.imageDateFormat = builder.comment("The format the date will be displayed on the IMAGE").translation("image_date_format").define("image_date_format", (Object)"MM/dd/yyyy HH:mm");
        }
    }
}

