/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.entity.player.EntityPlayerMP;

public class ImageTools {
    public static BufferedImage fromNativeImage(NativeImage nativeImage) {
        BufferedImage bufferedImage = new BufferedImage(nativeImage.func_195702_a(), nativeImage.func_195714_b(), 1);
        for (int x = 0; x < nativeImage.func_195702_a(); ++x) {
            for (int y = 0; y < nativeImage.func_195714_b(); ++y) {
                int rgba = nativeImage.func_195709_a(x, y);
                int alpha = ImageTools.getAlpha(rgba);
                int red = ImageTools.getRed(rgba);
                int green = ImageTools.getGreen(rgba);
                int blue = ImageTools.getBlue(rgba);
                bufferedImage.setRGB(x, y, ImageTools.getArgb(alpha, blue, green, red));
            }
        }
        return bufferedImage;
    }

    private static int getArgb(int a, int red, int green, int blue) {
        return a << 24 | red << 16 | green << 8 | blue;
    }

    private static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    private static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    private static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    private static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static NativeImage toNativeImage(BufferedImage bufferedImage) {
        NativeImage nativeImage = new NativeImage(bufferedImage.getWidth(), bufferedImage.getHeight(), false);
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                int rgba = bufferedImage.getRGB(x, y);
                int alpha = ImageTools.getAlpha(rgba);
                int red = ImageTools.getRed(rgba);
                int green = ImageTools.getGreen(rgba);
                int blue = ImageTools.getBlue(rgba);
                nativeImage.func_195700_a(x, y, ImageTools.getArgb(alpha, blue, green, red));
            }
        }
        return nativeImage;
    }

    public static byte[] toBytes(BufferedImage image) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        baos.flush();
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    public static BufferedImage fromBytes(byte[] data) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(bais);
        bais.close();
        return image;
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public static File getImageFile(EntityPlayerMP playerMP, UUID uuid) {
        File imageFolder = new File(playerMP.func_71121_q().func_72860_G().func_75765_b(), "camera_images");
        return new File(imageFolder, uuid.toString() + ".png");
    }

    public static void saveImage(EntityPlayerMP playerMP, UUID uuid, BufferedImage bufferedImage) throws IOException {
        File image = ImageTools.getImageFile(playerMP, uuid);
        image.mkdirs();
        ImageIO.write((RenderedImage)bufferedImage, "png", image);
    }

    public static BufferedImage loadImage(EntityPlayerMP playerMP, UUID uuid) throws IOException {
        File image = ImageTools.getImageFile(playerMP, uuid);
        FileInputStream fis = new FileInputStream(image);
        BufferedImage bufferedImage = ImageIO.read(fis);
        if (bufferedImage == null) {
            throw new IOException("BufferedImage is null");
        }
        return bufferedImage;
    }
}

