/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemTools {
    public static boolean isStackEmpty(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (stack.equals(ItemStack.field_190927_a)) {
            return true;
        }
        if (stack.func_77973_b().equals(Items.field_190931_a)) {
            return true;
        }
        return stack.func_190916_E() <= 0;
    }

    public static boolean areItemsEqualWithEmpty(ItemStack stack1, ItemStack stack2) {
        if (ItemTools.isStackEmpty(stack1) && ItemTools.isStackEmpty(stack2)) {
            return true;
        }
        return ItemTools.areItemsEqual(stack1, stack2);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() == null || stack2.func_77973_b() == null) {
            return false;
        }
        if (stack1.func_77973_b() == stack2.func_77973_b()) {
            return stack1.func_77952_i() == -1 || stack2.func_77952_i() == -1 || stack1.func_77952_i() == stack2.func_77952_i();
        }
        return false;
    }

    public static boolean contains(List<ItemStack> list, ItemStack item) {
        for (ItemStack i : list) {
            if (!ItemTools.areItemsEqual(item, i)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack itemStackAmount(int amount, ItemStack stack, EntityPlayer player) {
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        stack.func_190920_e(stack.func_190916_E() + amount);
        if (stack.func_190916_E() <= 0) {
            stack.func_190920_e(0);
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() > stack.func_77976_d()) {
            stack.func_190920_e(stack.func_77976_d());
        }
        return stack;
    }

    public static ItemStack decrItemStack(ItemStack stack, EntityPlayer player) {
        return ItemTools.itemStackAmount(-1, stack, player);
    }

    public static ItemStack incrItemStack(ItemStack stack, EntityPlayer player) {
        return ItemTools.itemStackAmount(1, stack, player);
    }

    public static ItemStack damageStack(ItemStack stack, int amount, EntityLivingBase entity) {
        stack.func_77972_a(amount, entity);
        return stack;
    }

    public static void removeStackFromSlot(IInventory inventory, int index) {
        inventory.func_70299_a(index, ItemStack.field_190927_a);
    }

    public static void saveInventory(NBTTagCompound compound, String name, IInventory inv) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (ItemTools.isStackEmpty(inv.func_70301_a(i))) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Slot", i);
            inv.func_70301_a(i).func_77955_b(nbttagcompound);
            nbttaglist.add((INBTBase)nbttagcompound);
        }
        compound.func_74782_a(name, (INBTBase)nbttaglist);
    }

    public static void readInventory(NBTTagCompound compound, String name, IInventory inv) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        NBTTagList nbttaglist = compound.func_150295_c(name, 10);
        if (nbttaglist == null) {
            return;
        }
        for (int i = 0; i < nbttaglist.size(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74762_e("Slot");
            if (j < 0 || j >= inv.func_70302_i_()) continue;
            inv.func_70299_a(j, ItemStack.func_199557_a((NBTTagCompound)nbttagcompound));
        }
    }
}

