/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ClientEvents;
import de.maxhenkel.camera.Config;
import de.maxhenkel.camera.ImageTaker;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.RecipeImageCloning;
import de.maxhenkel.camera.ServerEvents;
import de.maxhenkel.camera.entities.EntityImage;
import de.maxhenkel.camera.entities.RenderImage;
import de.maxhenkel.camera.gui.GUIManager;
import de.maxhenkel.camera.items.ItemAlbum;
import de.maxhenkel.camera.items.ItemCamera;
import de.maxhenkel.camera.items.ItemImage;
import de.maxhenkel.camera.items.ItemImageFrame;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import de.maxhenkel.camera.net.MessagePartialImage;
import de.maxhenkel.camera.net.MessageRequestImage;
import de.maxhenkel.camera.net.MessageResizeFrame;
import de.maxhenkel.camera.net.MessageSetShader;
import de.maxhenkel.camera.net.MessageTakeImage;
import de.maxhenkel.camera.net.PacketManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.RecipeSerializers;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="camera")
public class Main {
    public static final String MODID = "camera";
    private static Main instance;
    public static SimpleChannel SIMPLE_CHANNEL;
    public static PacketManager PACKET_MANAGER;
    public static final RecipeSerializers.SimpleSerializer<RecipeImageCloning> CRAFTING_SPECIAL_IMAGE_CLONING;
    @ObjectHolder(value="camera:image_frame")
    public static ItemImageFrame FRAME_ITEM;
    @ObjectHolder(value="camera:camera")
    public static ItemCamera CAMERA;
    @ObjectHolder(value="camera:image")
    public static ItemImage IMAGE;
    @ObjectHolder(value="camera:album")
    public static ItemAlbum ALBUM;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_NEXT;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_PREVIOUS;
    public static final EntityType<EntityImage> IMAGE_ENTITY_TYPE;

    public Main() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::configEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    @SubscribeEvent
    public void configEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            Config.loadServer();
        }
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "default"), () -> "1.0.0", s -> true, s -> true);
        PACKET_MANAGER = new PacketManager();
        SIMPLE_CHANNEL.registerMessage(0, MessagePartialImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessagePartialImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(1, MessageTakeImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageTakeImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(2, MessageRequestImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageRequestImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(3, MessageImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(4, MessageImageUnavailable.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageImageUnavailable().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(5, MessageSetShader.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageSetShader().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(6, MessageDisableCameraMode.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageDisableCameraMode().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(7, MessageResizeFrame.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageResizeFrame().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityImage.class, manager -> new RenderImage(manager));
        GUIManager.clientSetup();
        MinecraftForge.EVENT_BUS.register((Object)new ImageTaker());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        KEY_NEXT = new KeyBinding("key.next_image", 264, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_NEXT);
        KEY_PREVIOUS = new KeyBinding("key.previous_image", 265, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_PREVIOUS);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[4];
        FRAME_ITEM = new ItemImageFrame();
        itemArray[0] = FRAME_ITEM;
        CAMERA = new ItemCamera();
        itemArray[1] = CAMERA;
        IMAGE = new ItemImage();
        itemArray[2] = IMAGE;
        ALBUM = new ItemAlbum();
        itemArray[3] = ALBUM;
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{ModSounds.TAKE_IMAGE});
    }

    public static Main instance() {
        return instance;
    }

    static {
        CRAFTING_SPECIAL_IMAGE_CLONING = (RecipeSerializers.SimpleSerializer)RecipeSerializers.func_199573_a((IRecipeSerializer)new RecipeSerializers.SimpleSerializer("crafting_special_imagecloning", RecipeImageCloning::new));
        IMAGE_ENTITY_TYPE = EntityType.func_200712_a((String)"camera:image_frame", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityImage.class, EntityImage::new).tracker(256, 20, false));
    }
}

