/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.entities.EntityImage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class RenderImage
extends Render<EntityImage> {
    private static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    private static final ResourceLocation EMPTY_IMAGE = new ResourceLocation("camera", "textures/images/empty_image.png");
    private static final ResourceLocation FRAME_SIDE = new ResourceLocation("camera", "textures/images/frame_side.png");
    private static final ResourceLocation FRAME_BACK = new ResourceLocation("camera", "textures/images/frame_back.png");
    private static final double THICKNESS = 0.0625;
    private Minecraft mc = Minecraft.func_71410_x();

    public RenderImage(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityImage entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float ratioY;
        float ratioX;
        float imageRatio = 1.0f;
        boolean stretch = true;
        ResourceLocation resourceLocation = EMPTY_IMAGE;
        UUID imageUUID = entity.getImageUUID();
        if (imageUUID != null) {
            ResourceLocation rl = TextureCache.instance().getImage(imageUUID);
            if (rl != null) {
                resourceLocation = rl;
                NativeImage image = TextureCache.instance().getNativeImage(imageUUID);
                imageRatio = (float)image.func_195702_a() / (float)image.func_195714_b();
                stretch = false;
            } else {
                resourceLocation = DEFAULT_IMAGE;
                imageRatio = 1.5f;
                stretch = false;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x - 0.5), (double)y, (double)(z - 0.5));
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        EnumFacing facing = entity.getFacing();
        double width = entity.getWidth();
        double height = entity.getHeight();
        RenderImage.rotate(facing);
        this.func_110776_a(resourceLocation);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float frameRatio = (float)(width / height);
        float ratio = imageRatio / frameRatio;
        if (stretch) {
            ratioX = 0.0f;
            ratioY = 0.0f;
        } else {
            if (ratio >= 1.0f) {
                ratioY = (1.0f - 1.0f / ratio) / 2.0f;
                ratioX = 0.0f;
            } else {
                ratioX = (1.0f - ratio) / 2.0f;
                ratioY = 0.0f;
            }
            ratioX = (float)((double)ratioX * width);
            ratioY = (float)((double)ratioY * height);
        }
        buffer.func_181662_b(0.0 + (double)ratioX, (double)ratioY, 0.0625).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, (double)ratioY, 0.0625).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        this.func_110776_a(FRAME_SIDE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(1.0, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0625).func_187315_a(0.9375, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(0.9375, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(1.0, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(0.0, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(0.0, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(0.0625, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0625).func_187315_a(0.0625, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(0.0 + (double)ratioX, 1.0).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(0.0 + (double)ratioX, 0.9375).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(1.0 - (double)ratioX, 0.9375).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(1.0 - (double)ratioX, 1.0).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(0.0 + (double)ratioX, 0.0).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(1.0 - (double)ratioX, 0.0).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0625).func_187315_a(1.0 - (double)ratioX, 0.0625).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0625).func_187315_a(0.0 + (double)ratioX, 0.0625).func_181675_d();
        tessellator.func_78381_a();
        this.func_110776_a(FRAME_BACK);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(1.0 - (double)ratioX, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(0.0 + (double)ratioX, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(0.0 + (double)ratioX, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(1.0 - (double)ratioX, 1.0 - (double)ratioY).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        this.renderBoundingBox(entity, x, y, z);
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    private void renderBoundingBox(EntityImage entity, double x, double y, double z) {
        if (this.mc.field_71476_x == null || this.mc.field_71476_x.field_72308_g != entity) {
            return;
        }
        if (this.mc.field_71474_y.field_74319_N) {
            return;
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        WorldRenderer.func_189694_a((double)(axisalignedbb.field_72340_a - entity.field_70165_t + x), (double)(axisalignedbb.field_72338_b - entity.field_70163_u + y), (double)(axisalignedbb.field_72339_c - entity.field_70161_v + z), (double)(axisalignedbb.field_72336_d - entity.field_70165_t + x), (double)(axisalignedbb.field_72337_e - entity.field_70163_u + y), (double)(axisalignedbb.field_72334_f - entity.field_70161_v + z), (float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    public static void rotate(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                GlStateManager.func_179137_b((double)1.0, (double)0.0, (double)1.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                break;
            }
            case EAST: {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)1.0);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179137_b((double)1.0, (double)0.0, (double)0.0);
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityImage entity) {
        return DEFAULT_IMAGE;
    }
}

