/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.gui.ContainerImage;
import de.maxhenkel.camera.items.ItemImage;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiImage
extends GuiContainer {
    public static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    private UUID imageUUID;

    public GuiImage(ItemStack image) {
        super((Container)new ContainerImage());
        this.imageUUID = ItemImage.getUUID(image);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.imageUUID == null) {
            return;
        }
        GuiImage.drawImage(this.field_146297_k, this.field_146294_l, this.field_146295_m, this.field_73735_i, this.imageUUID);
    }

    public static void drawImage(Minecraft minecraft, int width, int height, float zLevel, UUID uuid) {
        float hnew;
        float wnew;
        GlStateManager.func_179094_E();
        ResourceLocation location = TextureCache.instance().getImage(uuid);
        float imageWidth = 12.0f;
        float imageHeight = 8.0f;
        if (location == null) {
            minecraft.func_110434_K().func_110577_a(DEFAULT_IMAGE);
        } else {
            minecraft.func_110434_K().func_110577_a(location);
            NativeImage image = TextureCache.instance().getNativeImage(uuid);
            imageWidth = image.func_195702_a();
            imageHeight = image.func_195714_b();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float scale = 0.8f;
        float ws = (float)width * scale;
        float hs = (float)height * scale;
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        buffer.func_181662_b((double)(left += (1.0f - scale) * ws / 2.0f), (double)(top += (1.0f - scale) * hs / 2.0f), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + hnew), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + wnew), (double)(top + hnew), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + wnew), (double)top, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

