/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.Config;
import de.maxhenkel.camera.gui.ContainerImage;
import de.maxhenkel.camera.gui.GuiImage;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemImage
extends Item {
    public ItemImage() {
        super(new Item.Properties().func_200917_a(1));
        this.setRegistryName(new ResourceLocation("camera", "image"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.field_70170_p.field_72995_K) {
            playerIn.func_180468_a(new IInteractionObject(){

                public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
                    return new ContainerImage();
                }

                public String func_174875_k() {
                    return "camera:image";
                }

                public ITextComponent func_200200_C_() {
                    return new TextComponentTranslation(ItemImage.this.func_77658_a(), new Object[0]);
                }

                public boolean func_145818_k_() {
                    return false;
                }

                @Nullable
                public ITextComponent func_200201_e() {
                    return null;
                }
            });
            this.openClientGui(stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiImage(stack));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        long time;
        String name = ItemImage.getOwner(stack);
        if (!name.isEmpty()) {
            tooltip.add(new TextComponentTranslation("tooltip.image_owner", new Object[]{TextFormatting.DARK_GRAY + name}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        if ((time = ItemImage.getTime(stack)) > 0L) {
            tooltip.add(new TextComponentTranslation("tooltip.image_time", new Object[]{TextFormatting.DARK_GRAY + Config.imageDateFormat.format(new Date(time))}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private static NBTTagCompound getImageTag(ItemStack stack) {
        NBTTagCompound compound;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("image")) {
            compound.func_74782_a("image", (INBTBase)new NBTTagCompound());
        }
        return compound.func_74775_l("image");
    }

    public static void setUUID(ItemStack stack, UUID uuid) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        compound.func_74772_a("image_id_most", uuid.getMostSignificantBits());
        compound.func_74772_a("image_id_least", uuid.getLeastSignificantBits());
    }

    public static UUID getUUID(ItemStack stack) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        if (!compound.func_74764_b("image_id_most") || !compound.func_74764_b("image_id_least")) {
            return null;
        }
        long most = compound.func_74763_f("image_id_most");
        long least = compound.func_74763_f("image_id_least");
        return new UUID(most, least);
    }

    public static void setTime(ItemStack stack, long time) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        compound.func_74772_a("image_time", time);
    }

    public static long getTime(ItemStack stack) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        if (!compound.func_74764_b("image_time")) {
            return 0L;
        }
        return compound.func_74763_f("image_time");
    }

    public static void setOwner(ItemStack stack, String name) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        compound.func_74778_a("owner", name);
    }

    public static String getOwner(ItemStack stack) {
        NBTTagCompound compound = ItemImage.getImageTag(stack);
        if (!compound.func_74764_b("owner")) {
            return "";
        }
        return compound.func_74779_i("owner");
    }
}

